/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network;

import com.splunk.mint.ActionNetwork;
import com.splunk.mint.Logger;
import com.splunk.mint.Properties;
import com.splunk.mint.network.Counter;
import com.splunk.mint.network.Metric;
import com.splunk.mint.network.MonitorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class NetLogManager {
    private static final long CONNECTION_TIMEOUT = 60000L;
    private static volatile HashMap<String, StartConnectionInfo> connectionsMap = new HashMap();
    private static NetLogManager mNetLogManager = null;

    public static synchronized String exceptionToString(Throwable e) {
        if (e == null) {
            return "NA";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public synchronized void startNetworkCall(String netCallID, String url, long startTime, String protocol) {
        if (netCallID != null) {
            netCallID = this.cleanUrl(netCallID);
            boolean toBeExcluded = this.checkIfURLisExcluded(url);
            if (!toBeExcluded) {
                StartConnectionInfo mStartConnectionInfo = new StartConnectionInfo();
                mStartConnectionInfo.startTime = startTime;
                mStartConnectionInfo.url = url;
                mStartConnectionInfo.protocol = protocol;
                connectionsMap.put(netCallID, mStartConnectionInfo);
                this.removeOldEntries();
            }
        }
    }

    public synchronized void endNetworkCall(MonitorRegistry registry, String netCallID, long stopTime, int statusCode) {
        if (netCallID != null) {
            StartConnectionInfo mSCI;
            netCallID = this.cleanUrl(netCallID);
            if (connectionsMap != null && connectionsMap.containsKey(netCallID) && (mSCI = connectionsMap.get(netCallID)) != null) {
                connectionsMap.remove(netCallID);
                Long bytesOut = 0L;
                long bytesIn = 0L;
                for (Metric<?> m : registry.getMetricsForName(netCallID)) {
                    if (!(m instanceof Counter)) continue;
                    if (((Counter)m).getName().endsWith("-bytes-out")) {
                        bytesOut = (Long)m.getValue();
                        continue;
                    }
                    if (!((Counter)m).getName().endsWith("-bytes-in")) continue;
                    bytesIn = (Long)m.getValue();
                }
                ActionNetwork.logNetwork(mSCI.url, mSCI.startTime, stopTime, mSCI.protocol, statusCode, String.valueOf(bytesOut), String.valueOf(bytesIn), null, null);
            }
        }
    }

    public synchronized void cancelNetworkCall(MonitorRegistry registry, String netCallID, long stopTime, String protocol, String exception) {
        if (netCallID != null) {
            StartConnectionInfo mSCI;
            netCallID = this.cleanUrl(netCallID);
            if (connectionsMap != null && connectionsMap.containsKey(netCallID) && (mSCI = connectionsMap.get(netCallID)) != null) {
                connectionsMap.remove(netCallID);
                ActionNetwork.logNetwork(mSCI.url, mSCI.startTime, stopTime, protocol, 0, "NA", "NA", exception, null);
            }
        }
    }

    public synchronized void logNetworkRequest(String url, String protocol, long startT, long endT, int statusCode, long requestLength, long responseLength, String exception, HashMap<String, Object> customData) {
        boolean toBeExcluded = this.checkIfURLisExcluded(url);
        if (!toBeExcluded) {
            ActionNetwork.logNetwork(url, startT, endT, protocol, statusCode, String.valueOf(requestLength), String.valueOf(responseLength), exception, customData);
        }
    }

    private synchronized void removeOldEntries() {
        Iterator<Map.Entry<String, StartConnectionInfo>> it = connectionsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, StartConnectionInfo> pairs = it.next();
            long startTime = pairs.getValue().startTime;
            if (System.currentTimeMillis() - startTime <= 60000L) continue;
            it.remove();
        }
    }

    public static synchronized NetLogManager getInstance() {
        if (mNetLogManager == null) {
            mNetLogManager = new NetLogManager();
        }
        return mNetLogManager;
    }

    private boolean checkIfURLisExcluded(String url) {
        if (url == null) {
            return true;
        }
        if (Properties.excludedUrls != null) {
            String clearUrl = this.cleanUrl(url);
            for (String excludedUrl : Properties.excludedUrls) {
                if (!clearUrl.contains(excludedUrl)) continue;
                return true;
            }
        }
        return false;
    }

    private String cleanUrl(String url) {
        if (url != null) {
            url = url.toLowerCase();
            url = url.replaceAll("https://", "");
            url = url.replaceAll("http://", "");
            url = url.replaceAll("www.", "");
        }
        return url;
    }

    public static boolean deviceSupporsNetworkMonitoring() {
        try {
            Class<?> implCl = Class.forName("java.net.PlainSocketImpl");
            if (implCl == null) {
                return false;
            }
            Constructor<?> delegateConstructor = implCl.getDeclaredConstructor(new Class[0]);
            if (delegateConstructor == null) {
                return false;
            }
            delegateConstructor.newInstance(new Object[0]);
            Logger.logInfo("Device supports Network Monitoring");
            return true;
        }
        catch (RuntimeException e) {
            Logger.logInfo("deviceSupporsNetworkMonitoring: " + e.getMessage());
        }
        catch (Exception e) {
            Logger.logInfo("deviceSupporsNetworkMonitoring: " + e.getMessage());
        }
        return false;
    }

    public static final int getStatusCodeFromURLConnection(URLConnection mURLConnection) {
        int statusCode = 0;
        if (mURLConnection != null) {
            if (mURLConnection instanceof HttpURLConnection) {
                try {
                    statusCode = ((HttpURLConnection)mURLConnection).getResponseCode();
                }
                catch (Exception exception) {}
            } else if (mURLConnection instanceof HttpsURLConnection) {
                try {
                    statusCode = ((HttpsURLConnection)mURLConnection).getResponseCode();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return statusCode;
    }

    class StartConnectionInfo {
        public String protocol;
        public Long startTime;
        public String url;
        public int statusCode;

        StartConnectionInfo() {
        }
    }
}

