/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.ChatContract;
import com.zoyi.channel.plugin.android.activity.chat.ChatPresenter;
import com.zoyi.channel.plugin.android.activity.chat.TypingManager;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnNewMessageAlertClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.view.ChatHeaderView;
import com.zoyi.channel.plugin.android.activity.chat.view.ChatNavigationView;
import com.zoyi.channel.plugin.android.activity.chat.view.NewMessageAlertView;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OnHeaderStateChangeListener;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OverlayHeaderCallback;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OverlayHeaderRecyclerView;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.UserChatSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.ImageFileStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.BottomFloatingActionLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.NewChatButton;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import java.util.concurrent.TimeUnit;

public class ChatActivity
extends BaseActivity
implements ChatContract.View,
EditTextChangedListener,
View.OnClickListener,
OnNewMessageAlertClickListener,
OverlayHeaderCallback,
OnHeaderStateChangeListener {
    private OverlayHeaderRecyclerView headerRecyclerView;
    private WatchedEditText editChat;
    private ImageButton imageSend;
    private View layoutInput;
    private NewMessageAlertView newMessageAlertView;
    private CHTextView disabledInputText;
    private ChatNavigationView chatNavigation;
    private BottomFloatingActionLayout bottomFloatingActionLayout;
    private NewChatButton newChatButton;
    @Nullable
    private BigBar bigBar;
    @Nullable
    private ChatHeaderView chatHeaderView;
    private LinearLayoutManager layoutManager;
    private TypingManager typingManager;
    private ChatContract.Presenter presenter;
    private ChatAdapter adapter;
    @Nullable
    private Subscription countSubscription;
    private boolean exit = false;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_chat);
        String chatId = null;
        if (this.getIntent() != null) {
            chatId = this.getIntent().getStringExtra("chatId");
        }
        this.bigBar = this.getBigBar();
        this.initBigBar();
        FragmentManager fm = this.getSupportFragmentManager();
        this.presenter = new ChatPresenter((Context)this);
        this.adapter = new ChatAdapter(TextUtils.isEmpty((CharSequence)chatId));
        this.presenter.setView(this);
        this.presenter.setAdapterModel(this.adapter);
        this.presenter.setAdapterView(this.adapter);
        this.presenter.setChatId(chatId);
        this.newMessageAlertView = (NewMessageAlertView)this.findViewById(R.id.view_new_message_alert);
        this.newMessageAlertView.setListener(this);
        this.headerRecyclerView = (OverlayHeaderRecyclerView)this.findViewById(R.id.recycler_header);
        this.imageSend = (ImageButton)this.findViewById(R.id.iv_chat_send);
        this.disabledInputText = (CHTextView)this.findViewById(R.id.text_disabled_input);
        this.editChat = (WatchedEditText)this.findViewById(R.id.edit_chat);
        this.layoutInput = this.findViewById(R.id.layout_input);
        this.newChatButton = (NewChatButton)this.findViewById(R.id.ch_button_new_chat);
        this.bottomFloatingActionLayout = (BottomFloatingActionLayout)this.findViewById(R.id.ch_layout_bottom_floating_action);
        this.typingManager = new TypingManager(chatId, this.editChat);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.layoutManager.setStackFromEnd(true);
        this.chatNavigation = new ChatNavigationView((Context)this);
        this.headerRecyclerView.getRecyclerView().setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.headerRecyclerView.getRecyclerView().setAdapter((RecyclerView.Adapter)this.adapter);
        this.headerRecyclerView.getRecyclerView().setItemAnimator(null);
        this.headerRecyclerView.addBannerView((View)this.chatNavigation);
        this.headerRecyclerView.setCallback(this);
        this.headerRecyclerView.setListener(this);
        this.headerRecyclerView.getRecyclerView().addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(this.layoutManager, 1, this.headerRecyclerView.getRecyclerView()){

            @Override
            public void scrolledInList() {
                ChatActivity.this.bottomFloatingActionLayout.hide();
            }

            @Override
            public void scrollAttachedToBottom() {
                ChatActivity.this.newMessageAlertView.hide();
                ChatActivity.this.bottomFloatingActionLayout.show();
            }

            @Override
            public void refresh() {
                ChatActivity.this.presenter.fetchBackwardMessages();
            }
        });
        this.bottomFloatingActionLayout.setRecyclerView(this.headerRecyclerView.getRecyclerView());
        this.findViewById(R.id.button_attach).setOnClickListener((View.OnClickListener)this);
        this.imageSend.setOnClickListener((View.OnClickListener)this);
        this.editChat.setWatchedTextChangedListener(this);
        this.editChat.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                ChatActivity.this.adapter.setChatEditTextFocus(hasFocus);
            }
        });
        this.editChat.setText(PrefSupervisor.getStoredMessage((Context)this));
        PrefSupervisor.clearStoredMessage((Context)this);
        this.newChatButton.setClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatActivity.this.setResult(22);
                ChatActivity.this.finish();
            }
        });
        this.setDisabledInputBoxView(false);
        Store.getInstance(ImageFileStore.class).clear();
        this.setBigbarStyle();
        this.presenter.init(chatId);
        if (SocketManager.isError()) {
            this.setReconnectVisibility(true);
        }
        this.bindChannel(ChannelSelector.getCurrentChannel());
        this.bindUserChat(UserChatSelector.get(chatId));
    }

    @Override
    protected void onDestroy() {
        if (this.presenter != null) {
            this.presenter.release();
        }
        if (this.countSubscription != null && !this.countSubscription.isUnsubscribed()) {
            this.countSubscription.unsubscribe();
        }
        Store.getInstance(TranslationStore.class).clearData();
        Store.getInstance(ImageFileStore.class).clear();
        super.onDestroy();
    }

    @Override
    public void finish() {
        if (this.presenter != null && this.presenter.getChatId() != null) {
            this.presenter.leaveChat();
        }
        super.finish();
    }

    private void initBigBar() {
        if (this.bigBar != null) {
            this.chatHeaderView = new ChatHeaderView((Context)this);
            this.bigBar.withActivity(this).addMenu(MenuButton.ActionType.SETTINGS, BigBar.MenuPosition.LEFT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT, MenuButton.MenuState.HIDDEN).addText(BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.REFRESH, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT).setHeaderView(this.chatHeaderView).build();
        }
        this.refreshChatCount(true);
        this.refreshMenuButton();
    }

    private void refreshChatCount(boolean force) {
        if (force) {
            if (this.bigBar != null) {
                this.bigBar.setText(CounterSelector.getTotalCounter());
            }
        } else {
            if (this.countSubscription != null && !this.countSubscription.isUnsubscribed()) {
                this.countSubscription.unsubscribe();
            }
            this.countSubscription = Observable.timer((long)600L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Long>(){

                public void call(Long aLong) {
                    if (ChatActivity.this.bigBar != null) {
                        ChatActivity.this.bigBar.setText(CounterSelector.getTotalCounter());
                    }
                }
            });
        }
    }

    private void refreshMenuButton() {
        if (this.bigBar != null) {
            if (UserChatSelector.getUserChatCount() > 0 || this.presenter != null && this.presenter.getUserChat() != null) {
                this.bigBar.setMenuState(MenuButton.ActionType.BACK, MenuButton.MenuState.VISIBLE);
                this.bigBar.setMenuState(MenuButton.ActionType.SETTINGS, MenuButton.MenuState.HIDDEN);
            } else {
                this.bigBar.setMenuState(MenuButton.ActionType.BACK, MenuButton.MenuState.HIDDEN);
                this.bigBar.setMenuState(MenuButton.ActionType.SETTINGS, MenuButton.MenuState.VISIBLE);
            }
        }
    }

    private void setBigbarStyle() {
        Channel channel = ChannelSelector.getCurrentChannel();
        if (channel != null && this.bigBar != null) {
            this.bigBar.setTitle(channel.getName());
        }
    }

    private void setDisabledInputBoxView(boolean isSocketEvent) {
        Channel channel = ChannelSelector.getCurrentChannel();
        if (channel != null) {
            if (isSocketEvent) {
                if (channel.isWorking() || "active".equals(channel.getAwayOption())) {
                    this.setDisabledInputBoxVisibility(false);
                }
            } else if (!channel.isWorking() && "disabled".equals(channel.getAwayOption())) {
                this.setDisabledInputBoxVisibility(true);
            } else {
                this.setDisabledInputBoxVisibility(false);
            }
        } else {
            this.setDisabledInputBoxVisibility(false);
        }
    }

    private void setDisabledInputBoxVisibility(boolean isDisabled) {
        this.disabledInputText.setVisibility(UIUtils.getVisible(isDisabled, true));
        this.layoutInput.setVisibility(UIUtils.getVisible(!isDisabled, true));
    }

    @Override
    public void onLoadUserChat(@Nullable UserChat userChat) {
        this.chatNavigation.bindUserChat(userChat);
        if (userChat == null) {
            this.headerRecyclerView.showBanner(true);
        }
        if (userChat != null) {
            this.typingManager.setChatId(userChat.getId());
        }
        if (this.bigBar != null) {
            this.bigBar.setOnClickListener(this);
        }
        this.refreshMenuButton();
    }

    @Override
    public void updateBackwardId(@Nullable String backwardId) {
    }

    @Override
    public void setInputLayoutVisibility(@Nullable String userChatState) {
        if (userChatState != null) {
            Views.setVisibility(this.layoutInput, CompareUtils.exists((Comparable)((Object)userChatState), (Comparable[])new String[]{"ready", "open", "following", "holding", "continue_chat"}));
            Views.setVisibility((View)this.newChatButton, CompareUtils.isSame(userChatState, "closed"));
            if (CompareUtils.exists((Comparable)((Object)userChatState), (Comparable[])new String[]{"solved", "closed"})) {
                this.hideKeyboard((EditText)this.editChat);
            }
            this.disabledInputText.setVisibility(8);
        }
    }

    @Override
    public void showRefreshButton() {
        if (this.bigBar != null) {
            this.bigBar.setMenuState(MenuButton.ActionType.REFRESH, MenuButton.MenuState.VISIBLE);
        }
    }

    @Override
    public boolean isMovableToBottomPosition() {
        int lastPosition = this.layoutManager.findLastVisibleItemPosition();
        return lastPosition <= this.adapter.getItemCount() - 2 && lastPosition >= this.adapter.getItemCount() - 4;
    }

    @Override
    public boolean isBottomPosition() {
        return this.layoutManager.findLastCompletelyVisibleItemPosition() >= this.adapter.getItemCount() - 2;
    }

    @Override
    public void scrollToPosition(int position) {
        this.layoutManager.scrollToPosition(position);
    }

    @Override
    public void scrollToBottom(boolean force) {
        if (this.layoutManager.findLastCompletelyVisibleItemPosition() == this.adapter.getItemCount() - 2 || force) {
            this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 902: {
                if (resultCode != 12) break;
                this.presenter.sendImageFiles(data.getStringArrayListExtra("PHOTO_INTENT_KEY"));
                break;
            }
            case 3001: {
                PhotoAlbumStorage.getInstance().release();
                break;
            }
            case 3002: {
                if (resultCode != 23) break;
                this.setResult(23);
            }
        }
    }

    @Override
    protected void receiveRxEvent(Object o) {
        super.receiveRxEvent(o);
    }

    @Override
    public void receiveCommand(Command command, @Nullable Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(Entity entity, boolean upsert) {
        this.presenter.receiveData(entity, upsert);
    }

    @Override
    public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
        switch (storeType) {
            case USER: 
            case VEIL: {
                this.refreshChatCount(false);
                break;
            }
            case USER_CHAT: {
                this.refreshMenuButton();
                UserChat userChat = (UserChat)entity;
                if (userChat == null) {
                    return;
                }
                if (CompareUtils.isSame(userChat.getId(), this.presenter.getChatId())) {
                    this.setInputLayoutVisibility(userChat.getState());
                    this.bottomFloatingActionLayout.bindUserChatState(userChat.getState());
                }
                this.bindUserChat(userChat);
                this.chatNavigation.bindUserChat(userChat);
                break;
            }
            case CHANNEL: {
                if (entity == null) break;
                this.bindChannel((Channel)entity);
            }
        }
    }

    @Override
    public void receiveTyping(Typing typing) {
        if (typing != null && typing.isOther() && typing.isSameChat(this.presenter.getChatId(), "UserChat")) {
            this.typingManager.refreshTypingExpiresAt(typing);
            this.presenter.receiveTyping(typing);
        }
    }

    @Override
    public void receiveLanguageEvent() {
        this.presenter.receiveLanguageEvent();
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        switch (actionType) {
            case REFRESH: {
                this.presenter.refresh();
                break;
            }
            case SETTINGS: {
                IntentUtils.setNextActivity((Context)this, SettingsActivity.class).setTransition(Transition.SLIDE_FROM_BOTTOM).startActivityForResult(3002);
                break;
            }
            case BACK: {
                this.onBackPressed();
                break;
            }
            case EXIT: {
                this.goToMain();
            }
        }
    }

    @Override
    public void setRefreshVisibility(boolean showRefresh) {
        if (this.bigBar != null) {
            this.bigBar.setMenuState(MenuButton.ActionType.REFRESH, showRefresh ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
        }
    }

    @Override
    public void setReconnectVisibility(boolean show) {
    }

    @Override
    public void setChannel(Channel channel) {
        this.bindChannel(channel);
        this.setDisabledInputBoxView(true);
        this.chatNavigation.bindChannel(channel);
    }

    @Override
    public void processNewMessage(@Nullable ProfileEntity profileEntity, @Nullable Message message) {
        if (profileEntity == null || message == null || message.getLog() != null) {
            return;
        }
        if (this.layoutManager.canScrollVertically() && !this.isBottomPosition()) {
            this.newMessageAlertView.show(profileEntity);
        }
    }

    @Override
    public void onNewMessageAlertClick() {
        this.scrollToBottom(true);
    }

    @Override
    public void setLastResponseManager(@Nullable Person person) {
    }

    @Override
    public void onRemovedChat() {
        this.finish();
    }

    @Override
    public void onWatchedTextChanged(String s) {
        this.imageSend.setEnabled(!TextUtils.isEmpty((CharSequence)s.trim()));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.button_attach) {
            this.hideKeyboard((EditText)this.editChat);
            IntentUtils.setNextActivity((Context)this, PhotoPickerActivity.class).startActivityForResult(902);
        }
        if (id2 == R.id.iv_chat_send) {
            this.presenter.sendTextMessage(this.editChat.getString());
            this.editChat.setText("");
        }
        if (id2 == R.id.big_bar) {
            this.headerRecyclerView.toggleBanner();
        }
    }

    @Override
    public void onFileDownload(File file) {
        if (file.getType() != null && file.getType().startsWith("video")) {
            IntentUtils.setNextActivity((Context)this, VideoViewerActivity.class).putExtra("filename", file.getName()).putExtra("url", file.getUrl()).startActivity();
        } else {
            IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", file.getUrl()).putExtra("filename", file.getFilename()).putExtra("image", file.isImage()).setTransition(Transition.NONE).startActivity();
        }
    }

    @Override
    public void onShowPhotoAlbum(File file) {
        IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("fileId", file.getId()).startActivityForResult(3001);
    }

    @Override
    public void onWebDescriptionClick(String url) {
        Executor.executeLinkAction((Context)this, url, LinkType.URL);
    }

    @Override
    public void onChangeProfileMessageFocus(boolean hasFocus) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.layoutInput.setBackground(ContextCompat.getDrawable((Context)this, (int)(hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg)));
        } else {
            this.layoutInput.setBackgroundDrawable(ContextCompat.getDrawable((Context)this, (int)(hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg)));
        }
    }

    public void onBackPressed() {
        if (!UserChatSelector.isEmpty() || this.presenter != null && this.presenter.getUserChat() != null) {
            this.finish();
        } else {
            this.goToMain();
        }
    }

    private void goToMain() {
        this.exit = true;
        this.setResult(24);
        this.finish();
    }

    @Override
    public void requestFocusEditText() {
        this.editChat.requestFocus();
    }

    @Override
    public void sendingMessageClicked(final SendingMessageItem item) {
        final AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.description")).setPositiveButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.retry_sending_message"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity.this.presenter.resend(item);
            }
        }).setNegativeButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.cancel"), null).setNeutralButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.delete"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity.this.presenter.removeFailedItem(item);
            }
        }).setCancelable(true).create();
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface args) {
                int dark = ContextCompat.getColor((Context)ChatActivity.this, (int)R.color.ch_dark);
                int cobalt = ContextCompat.getColor((Context)ChatActivity.this, (int)R.color.ch_cobalt);
                dialog.getButton(-1).setTextColor(cobalt);
                dialog.getButton(-2).setTextColor(dark);
                dialog.getButton(-3).setTextColor(dark);
            }
        });
        dialog.show();
    }

    @Override
    @AnimRes
    protected int getExistAnimOfFinish() {
        if (UserChatSelector.isEmpty() || this.exit) {
            return R.anim.ch_plugin_slide_out_bottom;
        }
        return R.anim.ch_plugin_slide_out_right;
    }

    @Override
    public boolean canScrollTop() {
        return this.presenter.getBackwardId() != null && !"zzzzzzzzzzzzzzzz".equals(this.presenter.getBackwardId());
    }

    @Override
    public void bindUserChat(@Nullable UserChat userChat) {
        if (this.chatHeaderView != null) {
            this.chatHeaderView.bindUserChat(userChat);
        }
        if (this.chatNavigation != null) {
            this.chatNavigation.bindUserChat(userChat);
        }
    }

    private void bindChannel(@Nullable Channel channel) {
        if (this.chatHeaderView != null) {
            this.chatHeaderView.bindChannel(channel);
        }
        if (this.chatNavigation != null) {
            this.chatNavigation.bindChannel(channel);
        }
    }

    @Override
    public void onBannerShow() {
        if (this.chatHeaderView != null) {
            this.chatHeaderView.setExpand(true);
        }
    }

    @Override
    public void onBannerHide() {
        if (this.chatHeaderView != null) {
            this.chatHeaderView.setExpand(false);
        }
    }
}

