/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.functions.Func2;
import com.zoyi.rx.internal.util.UtilityFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorDistinctUntilChanged<T, U>
implements Observable.Operator<T, T>,
Func2<U, U, Boolean> {
    final Func1<? super T, ? extends U> keySelector;
    final Func2<? super U, ? super U, Boolean> comparator;

    public static <T> OperatorDistinctUntilChanged<T, T> instance() {
        return Holder.INSTANCE;
    }

    public OperatorDistinctUntilChanged(Func1<? super T, ? extends U> keySelector) {
        this.keySelector = keySelector;
        this.comparator = this;
    }

    public OperatorDistinctUntilChanged(Func2<? super U, ? super U, Boolean> comparator) {
        this.keySelector = UtilityFunctions.identity();
        this.comparator = comparator;
    }

    @Override
    public Boolean call(U t1, U t2) {
        return t1 == t2 || t1 != null && t1.equals(t2);
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            U previousKey;
            boolean hasPrevious;

            @Override
            public void onNext(T t) {
                Object key;
                try {
                    key = OperatorDistinctUntilChanged.this.keySelector.call(t);
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, child, t);
                    return;
                }
                Object currentKey = this.previousKey;
                this.previousKey = key;
                if (this.hasPrevious) {
                    boolean comparison;
                    try {
                        comparison = OperatorDistinctUntilChanged.this.comparator.call(currentKey, key);
                    }
                    catch (Throwable e) {
                        Exceptions.throwOrReport(e, child, key);
                        return;
                    }
                    if (!comparison) {
                        child.onNext(t);
                    } else {
                        this.request(1L);
                    }
                } else {
                    this.hasPrevious = true;
                    child.onNext(t);
                }
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }
        };
    }

    static final class Holder {
        static final OperatorDistinctUntilChanged<?, ?> INSTANCE = new OperatorDistinctUntilChanged(UtilityFunctions.identity());

        Holder() {
        }
    }
}

