package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.PopupItem;
import com.zoyi.channel.plugin.android.util.AlarmCenter;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.channel.plugin.android.view.handler.CustomTextViewTouchListener;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

/**
 * Created by jerry on 2018. 11. 20..
 */

public class BasePopupView extends LinearLayout {

  private static final int MAX_POPUP_WIDTH = 534; // Max width (520) + side padding

  protected Context context;

  protected View root;
  protected ImageView buttonPopupClose;
  protected AvatarLayout avatarPopup;
  protected TextView textPopupBotName;
  protected TextView textPopupTime;
  protected TextView textPopupTitle;
  protected TextView textPopupMessage;
  protected ViewGroup layoutPopupContent;

  public BasePopupView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  // Resize popup width
  @Override
  protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    int maxPopupWidth = (int) Utils.dpToPx(MAX_POPUP_WIDTH);
    int popupWidth = View.MeasureSpec.getSize(widthMeasureSpec);

    if (maxPopupWidth < popupWidth) {
      popupWidth = maxPopupWidth;
    }

    widthMeasureSpec = MeasureSpec.makeMeasureSpec(popupWidth, MeasureSpec.getMode(widthMeasureSpec));

    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
  }

  @Initializer
  protected void init(Context context) {
    this.context = context;

    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_popup, this, true);
    root.setVisibility(GONE);

    buttonPopupClose = root.findViewById(R.id.ch_button_popup_close);
    avatarPopup = root.findViewById(R.id.ch_avatar_popup);
    textPopupBotName = root.findViewById(R.id.ch_text_popup_bot_name);
    textPopupTime = root.findViewById(R.id.ch_text_popup_time);

    textPopupTitle = root.findViewById(R.id.ch_text_popup_title);
    textPopupMessage = root.findViewById(R.id.ch_text_popup_message);
    layoutPopupContent = root.findViewById(R.id.ch_layout_popup_content);

    buttonPopupClose.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        hide();
      }
    });
  }

  protected void bindPopupData(@NonNull PopupItem popupItem) {

    // Reset popup content visibility (button, image.. etc)
    resetPopupContent();

    // Set avatar, bot name, time0
    
    ProfileEntity person = popupItem.getProfile();
    avatarPopup.set(person);
    textPopupBotName.setText(person != null ? person.getName() : ResUtils.getUnknown());
    textPopupTime.setText(TimeUtils.getTime(popupItem.getCreatedAt()));

    // Set title (optional)
    Views.setVisibility(textPopupTitle, popupItem.getTitle() != null);
    textPopupTitle.setText(popupItem.getTitle());

    // Set message
    String message = popupItem.getMessage();

    if (MessageParser.get() != null) {
      SpannableStringBuilder formattedMessage = MessageParser.get().parse(message);

      textPopupMessage.setOnTouchListener(new CustomTextViewTouchListener(formattedMessage));
      textPopupMessage.setText(formattedMessage);
    } else {
      textPopupMessage.setText(message);
    }

    // Set alarm
    if (PrefSupervisor.isEnabledPushAlarm(context)) {
      AlarmCenter.alarm(context);
    }
  }

  public void hide() {
    root.setVisibility(GONE);
  }

  private void resetPopupContent() {
    for (int i = 0; i < layoutPopupContent.getChildCount(); i++) {
      layoutPopupContent.getChildAt(i).setVisibility(View.GONE);
    }
  }
}
