/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.PopupItem;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.model.rest.PushBot;
import com.zoyi.channel.plugin.android.model.rest.PushBotVariant;
import com.zoyi.channel.plugin.android.selector.BotSelector;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class PushBotItem
implements Entity,
PopupItem {
    @NonNull
    private PushBot pushBot;
    @Nullable
    private PushBotVariant pushBotVariant;
    private long createdAt;
    private int alertCount;
    private boolean removed;

    public static PushBotItem newInstance(@NonNull PushBot pushBot, @Nullable PushBotVariant pushBotVariant) {
        return new PushBotItem(pushBot, pushBotVariant);
    }

    private PushBotItem(@NonNull PushBot pushBot, @Nullable PushBotVariant pushBotVariant) {
        this.pushBot = pushBot;
        this.pushBotVariant = pushBotVariant;
        this.createdAt = TimeUtils.getCurrentTime();
        this.alertCount = 1;
        this.removed = false;
    }

    @Override
    @NonNull
    public String getId() {
        return this.pushBot.getId();
    }

    @Override
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Nullable
    public ProfileEntity getProfile() {
        if (this.pushBotVariant != null) {
            return BotSelector.getBotByName(this.pushBotVariant.getBotName());
        }
        return null;
    }

    @Nullable
    public String getBotId() {
        Bot bot;
        if (this.pushBotVariant != null && (bot = BotSelector.getBotByName(this.pushBotVariant.getBotName())) != null) {
            return bot.getId();
        }
        return null;
    }

    @Override
    @Nullable
    public String getTitle() {
        if (this.pushBotVariant != null) {
            return this.pushBotVariant.getTitle();
        }
        return null;
    }

    @Override
    @Nullable
    public String getMessage() {
        if (this.pushBotVariant != null) {
            return this.pushBotVariant.getMessage();
        }
        return null;
    }

    @Nullable
    public String getButtonTitle() {
        if (this.pushBotVariant != null) {
            return this.pushBotVariant.getButtonTitle();
        }
        return null;
    }

    @Nullable
    public String getButtonRedirectUrl() {
        if (this.pushBotVariant != null) {
            return this.pushBotVariant.getButtonRedirectUrl();
        }
        return null;
    }

    @Nullable
    public PreviewThumb getImageThumb() {
        if (this.pushBotVariant != null) {
            return this.pushBotVariant.getImageThumb();
        }
        return null;
    }

    @Nullable
    public String getAttachment() {
        if (this.pushBotVariant != null) {
            return this.pushBotVariant.getAttachment();
        }
        return null;
    }

    @Nullable
    public String getImageRedirectUrl() {
        if (this.pushBotVariant != null) {
            return this.pushBotVariant.getImageRedirectUrl();
        }
        return null;
    }

    public int getAlertCount() {
        return this.alertCount;
    }

    public void read() {
        this.alertCount = 0;
    }

    public void remove() {
        this.alertCount = 0;
        this.removed = true;
    }

    public boolean shouldShowToList() {
        return this.pushBotVariant != null && !this.removed;
    }
}

