/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.evaluation;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.evaluation.EnvironmentInfo;
import com.zoyi.channel.plugin.android.model.rest.TargetCondition;
import com.zoyi.channel.plugin.android.util.L;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Pattern;

public class EvaluationUtils {
    public static boolean evaluateTarget(List<List<TargetCondition>> target, EnvironmentInfo environmentInfo) {
        for (List<TargetCondition> conditions : target) {
            if (EvaluationUtils.evaluateConditions(conditions, environmentInfo)) continue;
            return false;
        }
        return true;
    }

    private static boolean evaluateConditions(List<TargetCondition> conditions, EnvironmentInfo environmentInfo) {
        for (TargetCondition condition : conditions) {
            if (!EvaluationUtils.evaluateCondition(condition, environmentInfo)) continue;
            return true;
        }
        return false;
    }

    private static boolean evaluateCondition(TargetCondition condition, EnvironmentInfo environmentInfo) {
        String key = condition.getKey();
        String subKey = condition.getSubKey();
        String operator = condition.getOperator();
        if (key == null || operator == null) {
            return false;
        }
        try {
            Object value = subKey != null ? environmentInfo.getValueBySubKey(key, subKey) : environmentInfo.getValueByKey(key);
            return EvaluationUtils.evaluate(condition.getValue(), value, operator);
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                L.e("Evaluate exception : " + exception.getMessage());
            }
            return false;
        }
    }

    public static boolean evaluate(@Nullable String target, @Nullable Object value, String operator) throws Exception {
        switch (operator) {
            case "$eq": {
                return EvaluationUtils.evaluateEqual(target, value);
            }
            case "$ne": {
                return EvaluationUtils.evaluateNotEqual(target, value);
            }
            case "$in": {
                return EvaluationUtils.evaluateIn(target, value);
            }
            case "$nin": {
                return EvaluationUtils.evaluateNotIn(target, value);
            }
            case "$prefix": {
                return EvaluationUtils.evaluatePrefix(target, value);
            }
            case "$nprefix": {
                return EvaluationUtils.evaluateNotPrefix(target, value);
            }
            case "$regex": {
                return EvaluationUtils.evaluateRegex(target, value);
            }
            case "$exist": {
                return EvaluationUtils.evaluateExist(value);
            }
            case "$nexist": {
                return EvaluationUtils.evaluateNotExist(value);
            }
            case "$gt": 
            case "$gte": 
            case "$lt": 
            case "$lte": {
                return EvaluationUtils.evaluateNumberTypeOperator(target, value, operator);
            }
        }
        return false;
    }

    private static boolean evaluateEqual(@Nullable String target, @Nullable Object value) {
        return target != null && value != null && value.toString().equals(target);
    }

    private static boolean evaluateNotEqual(@Nullable String target, @Nullable Object value) {
        return target != null && value != null && !value.toString().equals(target);
    }

    private static boolean evaluateIn(@Nullable String target, @Nullable Object value) {
        return target != null && value != null && value.toString().contains(target);
    }

    private static boolean evaluateNotIn(@Nullable String target, @Nullable Object value) {
        return target != null && value != null && !value.toString().contains(target);
    }

    private static boolean evaluatePrefix(@Nullable String target, @Nullable Object value) {
        return target != null && value != null && value.toString().startsWith(target);
    }

    private static boolean evaluateNotPrefix(@Nullable String target, @Nullable Object value) {
        return target != null && value != null && !value.toString().startsWith(target);
    }

    private static boolean evaluateRegex(@Nullable String target, @Nullable Object value) {
        return target != null && value != null && Pattern.matches(target, value.toString());
    }

    private static boolean evaluateExist(@Nullable Object value) {
        return value != null;
    }

    private static boolean evaluateNotExist(@Nullable Object value) {
        return value == null;
    }

    private static boolean evaluateNumberTypeOperator(@Nullable String target, @Nullable Object value, String operator) throws Exception {
        if (target == null || value == null) {
            return false;
        }
        BigDecimal targetDecimal = new BigDecimal(target);
        BigDecimal valueDecimal = new BigDecimal(value.toString());
        switch (operator) {
            case "$gt": {
                return EvaluationUtils.evaluateGT(targetDecimal, valueDecimal);
            }
            case "$gte": {
                return EvaluationUtils.evaluateGTE(targetDecimal, valueDecimal);
            }
            case "$lt": {
                return EvaluationUtils.evaluateLT(targetDecimal, valueDecimal);
            }
            case "$lte": {
                return EvaluationUtils.evaluateLTE(targetDecimal, valueDecimal);
            }
        }
        return false;
    }

    private static boolean evaluateGT(BigDecimal target, BigDecimal value) {
        return value.compareTo(target) > 0;
    }

    private static boolean evaluateGTE(BigDecimal target, BigDecimal value) {
        return value.compareTo(target) >= 0;
    }

    private static boolean evaluateLT(BigDecimal target, BigDecimal value) {
        return value.compareTo(target) < 0;
    }

    private static boolean evaluateLTE(BigDecimal target, BigDecimal value) {
        return value.compareTo(target) <= 0;
    }
}

