package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

/**
 * Created by mika on 2017. 1. 31..
 */
public abstract class ProfileLayout extends FrameLayout {

  protected static final int DEFAULT_TEXT_SIZE = 16;

  protected ImageView back;
  protected ImageView image;
  protected CHTextView text;

  protected int textSize = DEFAULT_TEXT_SIZE;

  public ProfileLayout(Context context) {
    super(context);
  }

  public ProfileLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public ProfileLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  public ProfileLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    super(context, attrs, defStyleAttr, defStyleRes);
  }

  @Initializer
  protected void init(Context context, View root, @Nullable AttributeSet attrs) {
    textSize = DEFAULT_TEXT_SIZE;

    back = root.findViewById(R.id.back_profile);
    image = root.findViewById(R.id.image_profile);
    text =  root.findViewById(R.id.text_profile);

    if (attrs != null) {
      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
          attrs,
          R.styleable.ProfileLayout,
          0,
          0);

      try {
        textSize = typedArray.getDimensionPixelSize(R.styleable.ProfileLayout_ch_initial_text_size, textSize);
      } finally {
        typedArray.recycle();
      }
    }

    text.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
  }

  public void set(@Nullable ProfileEntity entity) {
    if (entity == null || entity.getAvatarUrl() == null) {
      image.setVisibility(View.GONE);

      back.setBackgroundColor(Color.BLACK);
      text.setTextColor(Color.WHITE);
      text.setText("?");
      text.setVisibility(View.VISIBLE);
    } else {
      image.setVisibility(View.VISIBLE);
      back.setBackgroundColor(Color.WHITE);
      text.setVisibility(View.GONE);

      Glide.with(getContext())
          .load(entity.getAvatarUrl())
          .centerCrop()
          .dontAnimate()
          .diskCacheStrategy(DiskCacheStrategy.RESULT)
          .into(image);
    }
  }

  public void set(@DrawableRes int resId) {
    image.setImageResource(resId);
    image.setVisibility(View.VISIBLE);
    back.setBackgroundColor(Color.WHITE);
    text.setVisibility(View.GONE);
  }

  public void setTextSize(int size) {
    if (text != null) {
      text.setTextSize(TypedValue.COMPLEX_UNIT_SP, size);
    }
  }
}
