package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;

import java.util.Map;

import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2016. 12. 22..
 */
public class SendingMessageItem implements MessageItem {

  @Nullable
  private String chatId;
  @Nullable
  private String string;
  private String requestId;

  private boolean image;
  private boolean sending;
  private Long createdAt;
  @Nullable
  private Map<String, String> submit;


  public SendingMessageItem(String requestId, Long createdAt) {
    this.requestId = requestId;
    this.createdAt = createdAt;
  }

  public SendingMessageItem(@Nullable String chatId, @Nullable String string, boolean image) {
    this.requestId = "";
    this.createdAt = 0L;
    this.chatId = chatId;
    this.string = string;
    this.image = image;
    this.sending = true;
    refreshCreatedAt();
  }

  @Override
  public Long getPrimaryKey() {
    return createdAt;
  }

  @Override
  public String getSecondaryKey() {
    return requestId;
  }

  @Nullable
  public String getRequestId() {
    return requestId;
  }

  @Override
  public MessageType getType() {
    return MessageType.SENDING;
  }

  @Nullable
  public String getChatId() {
    return chatId;
  }

  public boolean isSending() {
    return sending;
  }

  public void setSending(boolean sending) {
    this.sending = sending;
  }

  @Nullable
  public String getString() {
    return string;
  }

  public boolean isImage() {
    return image;
  }

  @Nullable
  public static SendingMessageItem create(String requestId) {
    if (requestId == null) {
      return null;
    }

    try {
      return new SendingMessageItem(requestId, Long.parseLong(requestId));
    } catch (Exception ex) {
      return null;
    }
  }

  @Nullable
  public String getMessage() {
    return string;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public void setChatId(String chatId) {
    this.chatId = chatId;
  }

  @Nullable
  public Map<String, String> getSubmit() {
    return submit;
  }

  public void setSubmit(Map<String, String> submit) {
    this.submit = submit;
  }

  private static int count = 0;

  public void refreshCreatedAt() {
    long now = System.currentTimeMillis() * 100 + (count % 100);
    this.requestId = String.valueOf(now);
    this.createdAt = now;

    count = (count + 1) % 100;
  }

  public boolean isConnected(@Nullable MessageItem p2) {
    if (p2 == null || !(p2 instanceof ChatMessageItem)) {
      return false;
    }

    Message m2 = ((ChatMessageItem) p2).getMessage();

    String t1 = TimeUtils.get(TimeUtils.MINUTE_24, System.currentTimeMillis());
    String t2 = TimeUtils.get(TimeUtils.MINUTE_24, m2.getCreatedAt());
    return CompareUtils.compare(t1, t2) == 0;
  }

}
