package com.zoyi.channel.plugin.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class ChannelPluginSettings {
  @Nullable
  private String pluginKey;
  @Nullable
  private String userId;
  private boolean debugMode;
  private boolean enabledTrackDefaultEvent;
  private boolean hideDefaultInAppPush;
  @Nullable
  private CHLocale locale;
  @Nullable
  private LauncherConfig launcherConfig;

  public ChannelPluginSettings(@Nullable String pluginKey) {
    this.pluginKey = pluginKey;
    this.debugMode = false;
    this.enabledTrackDefaultEvent = true;
    this.hideDefaultInAppPush = false;
    this.locale = CHLocale.DEVICE;
  }

  public static ChannelPluginSettings create(@Nullable String pluginKey) {
    return new ChannelPluginSettings(pluginKey);
  }

  public ChannelPluginSettings setUserId(@Nullable String userId) {
    this.userId = userId;
    return this;
  }

  public ChannelPluginSettings setDebugMode(boolean debug) {
    this.debugMode = debug;
    return this;
  }

  public ChannelPluginSettings setEnabledTrackDefaultEvent(boolean enabledTrackDefaultEvent) {
    this.enabledTrackDefaultEvent = enabledTrackDefaultEvent;
    return this;
  }

  public ChannelPluginSettings setHideDefaultInAppPush(boolean hideDefaultInAppPush) {
    this.hideDefaultInAppPush = hideDefaultInAppPush;
    return this;
  }

  public ChannelPluginSettings setLocale(@Nullable CHLocale locale) {
    this.locale = locale;
    return this;
  }

  public ChannelPluginSettings setLauncherConfig(@Nullable LauncherConfig launcherConfig) {
    this.launcherConfig = launcherConfig;
    return this;
  }

  @Nullable
  public String getPluginKey() {
    return pluginKey;
  }

  @Nullable
  public String getUserId() {
    return userId;
  }

  public boolean isDebugMode() {
    return debugMode;
  }

  public boolean isEnabledTrackDefaultEvent() {
    return enabledTrackDefaultEvent;
  }

  public boolean isHideDefaultInAppPush() {
    return hideDefaultInAppPush;
  }

  @Nullable
  public CHLocale getLocale() {
    return locale;
  }

  @Nullable
  public LauncherConfig getLauncherConfig() {
    return launcherConfig;
  }
}
