/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.L;

public class ActivityLifecycleManager
implements Application.ActivityLifecycleCallbacks {
    @Nullable
    private Activity topActivity;
    private int running = 0;

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        L.d("onStart: " + activity.getClass().getSimpleName());
    }

    public void onActivityStarted(Activity activity) {
        L.d("Started: " + activity.getClass().getSimpleName() + " " + this.running + " -> " + (this.running + 1));
        this.topActivity = activity;
        if (++this.running == 1) {
            RxBus.post(new CommandBus(Command.APP_STARTED));
            SocketManager.connect();
        }
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        L.d("Stopped: " + activity.getClass().getSimpleName() + " " + this.running + " -> " + (this.running - 1));
        if (this.topActivity == activity) {
            this.topActivity = null;
        }
        if (--this.running == 0) {
            SocketManager.disconnect();
            RxBus.post(new CommandBus(Command.APP_STOPPED));
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        L.d("onDestroy: " + activity.getClass().getSimpleName());
        if (activity instanceof UserChatListActivity) {
            for (ChannelPluginListener l : ChannelIOManager.getChannelPluginListeners()) {
                if (l == null) continue;
                l.willHideMessenger();
            }
        }
    }

    @Nullable
    Activity getTopActivity() {
        return this.topActivity;
    }

    public void finish(boolean animated) {
        if (this.topActivity != null && this.topActivity instanceof BaseActivity) {
            this.topActivity.setResult(21);
            ((BaseActivity)this.topActivity).finish(animated);
        }
    }
}

