/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.unsafe;

import com.zoyi.rx.internal.util.SuppressAnimalSniffer;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueueL3Pad;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressAnimalSniffer
public final class SpscArrayQueue<E>
extends SpscArrayQueueL3Pad<E> {
    public SpscArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException("null elements not allowed");
        }
        Object[] lElementBuffer = this.buffer;
        long index = this.producerIndex;
        long offset = this.calcElementOffset(index);
        if (null != this.lvElement(lElementBuffer, offset)) {
            return false;
        }
        this.soElement(lElementBuffer, offset, e);
        this.soProducerIndex(index + 1L);
        return true;
    }

    @Override
    public E poll() {
        Object[] lElementBuffer = this.buffer;
        long index = this.consumerIndex;
        long offset = this.calcElementOffset(index);
        Object e = this.lvElement(lElementBuffer, offset);
        if (null == e) {
            return null;
        }
        this.soElement(lElementBuffer, offset, null);
        this.soConsumerIndex(index + 1L);
        return (E)e;
    }

    @Override
    public E peek() {
        return this.lvElement(this.calcElementOffset(this.consumerIndex));
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvProducerIndex() == this.lvConsumerIndex();
    }

    private void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    private void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }
}

