package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.PluginSelector;

/**
 * Created by jerry on 2018. 8. 13..
 */

public class NewChatButton extends FrameLayout {

  private View root;
  private LinearLayout layoutNewChatButton;
  private CHTextView textNewChatButton;

  public NewChatButton(Context context) {
    super(context);
    init(context);
  }

  public NewChatButton(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public NewChatButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_new_chat, this);

    layoutNewChatButton = root.findViewById(R.id.ch_layout_new_chat_button);
    textNewChatButton = root.findViewById(R.id.ch_text_new_chat_button);

    Plugin plugin = PluginSelector.getPlugin();

    layoutNewChatButton.setBackgroundColor(plugin != null ? plugin.getBackgroundColor() : Color.BLACK);
    textNewChatButton.setTextColor(plugin != null && plugin.getBackgroundColor() != Color.BLACK ? plugin.getTextColor() : Color.WHITE);
  }

   public void setClickListener(View.OnClickListener listener) {
    layoutNewChatButton.setOnClickListener(listener);
  }
}
