/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.store;

import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.RecordUpdatesCollectionStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.Collection;

public class UserChatStore
extends RecordUpdatesCollectionStore<UserChat> {
    private boolean showClosed = true;
    private boolean canUpdate = false;

    @Override
    protected StoreType getStoreType() {
        return StoreType.USER_CHAT;
    }

    @Override
    protected boolean canUpdate(UserChat oldbie, UserChat newbie) {
        return super.canUpdate(oldbie, newbie) && this.canUpdate;
    }

    @Override
    public synchronized void set(Collection<UserChat> list) {
        this.canUpdate = true;
        super.set(list);
    }

    public void setCanUpdate(boolean canUpdate) {
        this.canUpdate = canUpdate;
    }

    public void setShowClosed(boolean showClosed) {
        this.showClosed = showClosed;
    }

    public boolean shouldShowClosedChat() {
        return this.showClosed;
    }

    public String[] getBlockFilters() {
        return (this.showClosed ? "removed" : "closed&removed").split("&");
    }

    @Override
    protected void updated(UserChat userChat) {
        if (userChat != null) {
            if (CompareUtils.exists((Comparable)((Object)userChat.getState()), (Comparable[])this.getBlockFilters())) {
                this.removed(userChat);
            } else {
                super.updated(userChat);
            }
        }
    }
}

