/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.form;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFormMessageClickListener;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class FormButtonView
extends LinearLayout
implements View.OnTouchListener {
    private Context context;
    private MaskableFrameLayout leftRoundHeaderLayout;
    private MaskableFrameLayout roundHeaderLayout;
    private View leftRoundHeader;
    private View roundHeader;
    private CHTextView buttonText;
    @Nullable
    private OnFormMessageClickListener onClickListener;
    private ActionInput actionInput;
    @Nullable
    private String actionType;
    private int COLOR_DARK_80;
    private int COLOR_WHITE;
    private boolean clicked;

    public FormButtonView(Context context, @Nullable String actionType, ActionInput actionInput, @Nullable OnFormMessageClickListener onClickListener) {
        super(context);
        this.init(context, actionType, actionInput, onClickListener);
    }

    private void init(Context context, @Nullable String actionType, ActionInput actionInput, @Nullable OnFormMessageClickListener clickListener) {
        this.context = context;
        this.actionType = actionType;
        this.actionInput = actionInput;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_form_button, (ViewGroup)this);
        this.leftRoundHeaderLayout = (MaskableFrameLayout)view.findViewById(R.id.ch_layout_form_message_head);
        this.roundHeaderLayout = (MaskableFrameLayout)view.findViewById(R.id.ch_layout_form_message_content);
        this.leftRoundHeader = view.findViewById(R.id.ch_view_form_message_head_top);
        this.roundHeader = view.findViewById(R.id.ch_view_form_message_content_top);
        this.buttonText = (CHTextView)view.findViewById(R.id.ch_text_form_message_complete);
        this.buttonText.setText(actionInput.getValue());
        this.leftRoundHeader.setVisibility(8);
        this.roundHeader.setVisibility(0);
        this.COLOR_DARK_80 = ContextCompat.getColor((Context)context, (int)R.color.ch_dark_80);
        this.COLOR_WHITE = ContextCompat.getColor((Context)context, (int)R.color.ch_white);
        this.clicked = false;
        this.setButtonText(actionInput);
        this.setListener(clickListener);
        this.changeColor(false);
    }

    private void setButtonText(ActionInput actionInput) {
        this.buttonText.setMaxLines(2);
        this.buttonText.setEllipsize(TextUtils.TruncateAt.END);
        this.buttonText.setTextColor(this.COLOR_DARK_80);
        if (MessageParser.get() != null) {
            this.buttonText.setText((CharSequence)MessageParser.get().parse(actionInput.getValue()));
        }
    }

    private void setListener(@Nullable OnFormMessageClickListener clickListener) {
        this.setOnTouchListener(this);
        this.onClickListener = clickListener;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.changeColor(!this.clicked);
                break;
            }
            case 3: {
                this.changeColor(this.clicked);
                break;
            }
            case 1: {
                boolean bl = this.clicked = !this.clicked;
                if (this.onClickListener == null) break;
                this.onClickListener.onFormMessageClick(this.actionType, this.actionInput);
            }
        }
        return true;
    }

    private void changeColor(boolean isClicked) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setColor(isClicked ? ColorSelector.getBackgroundColor() : this.COLOR_WHITE);
        drawable2.setStroke((int)Utils.dpToPx(this.context, 1.0f), isClicked ? ColorSelector.getBackgroundColor() : this.COLOR_DARK_80);
        drawable2.setCornerRadius((float)((int)Utils.dpToPx(this.context, 15.0f)));
        this.roundHeader.setBackgroundDrawable((Drawable)drawable2);
        this.buttonText.setBackgroundDrawable((Drawable)drawable2);
        this.buttonText.setTextColor(isClicked ? this.COLOR_WHITE : this.COLOR_DARK_80);
    }
}

