/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message_format.message;

import android.text.SpannableStringBuilder;
import android.text.style.UnderlineSpan;
import android.util.Patterns;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.message_format.message.MessagePattern;
import com.zoyi.channel.plugin.android.util.message_format.span.LinkSpan;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkMessage
implements MessagePattern {
    private final Pattern linkPattern = Pattern.compile("(\\[[^\\n<>\\[\\]]+])?<[^\\n<>\\[\\]]+>");
    private final Pattern expendedLinkPattern = Pattern.compile("\\[.+]<.+>");
    private final Pattern mentionPattern = Pattern.compile("<@[a-zA-Z0-9]+>");
    private int linkColor;

    public LinkMessage(int linkColor) {
        this.linkColor = linkColor;
    }

    @Override
    public SpannableStringBuilder parse(SpannableStringBuilder span) {
        Matcher linkMatcher = this.linkPattern.matcher((CharSequence)span);
        while (linkMatcher.find()) {
            try {
                String linkableText;
                int start = linkMatcher.start();
                int end = linkMatcher.end();
                String matchedText = span.toString().substring(start, end);
                String plainText = span.toString();
                Matcher expendedLinkMatcher = this.expendedLinkPattern.matcher(matchedText);
                if (expendedLinkMatcher.find()) {
                    int center = plainText.indexOf("]<") + 1;
                    linkableText = plainText.substring(center + 1, end - 1);
                    span.delete(center, end);
                    end = center;
                    span.delete(end - 1, end);
                    span.delete(start, start + 1);
                } else {
                    linkableText = plainText.substring(start + 1, end - 1);
                    span.delete(end - 1, end);
                    span.delete(start, start + 1);
                }
                if (!this.mentionPattern.matcher(matchedText).find()) {
                    span.setSpan((Object)new LinkSpan(linkableText, this.getLinkType(linkableText), this.linkColor), start, end - 2, 33);
                    span.setSpan((Object)new UnderlineSpan(), start, end - 2, 33);
                }
                linkMatcher = this.linkPattern.matcher((CharSequence)span);
            }
            catch (IndexOutOfBoundsException indexException) {
                L.e(indexException.getMessage());
                return span;
            }
        }
        return span;
    }

    private LinkType getLinkType(String linkText) {
        Matcher webMatcher = Patterns.WEB_URL.matcher(linkText);
        Matcher emailMatcher = Patterns.EMAIL_ADDRESS.matcher(linkText);
        Matcher phoneMatcher = Patterns.PHONE.matcher(linkText);
        if (emailMatcher.find()) {
            return LinkType.EMAIL;
        }
        if (webMatcher.find()) {
            return LinkType.URL;
        }
        if (phoneMatcher.find()) {
            return LinkType.PHONE;
        }
        return LinkType.PLAIN_TEXT;
    }
}

