/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;
import java.io.IOException;

public class RetrofitInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Channel channel;
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        builder = builder.header("Accept-Language", PrefSupervisor.getPluginLanguage(ChannelIO.getAppContext()));
        String veilId = GuestSelector.getVeilId();
        String userId = GuestSelector.getUserId();
        if (veilId != null) {
            builder.header("X-Veil-Id", veilId);
        }
        if (userId != null) {
            builder.header("X-User-Id", userId);
        }
        if ((channel = ChannelSelector.getCurrentChannel()) != null && channel.getId() != null) {
            builder.header("X-Channel-Id", channel.getId());
        }
        return chain.proceed(builder.build());
    }
}

