package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.File;

import java.util.Locale;

/**
 * Created by mika on 2017. 2. 3..
 */
public class ResUtils {
  public static int getFileIconResourceId(File file) {
    if (file == null || file.getExtension() == null) {
      return R.drawable.ch_plugin_file_else;
    }

    switch (file.getExtension()) {
      case "archive":
        return R.drawable.ch_plugin_file_zip;
      case "image":
        return R.drawable.ch_plugin_file_image;
      case "script":
        return R.drawable.ch_plugin_file_script;
      case "system":
        return R.drawable.ch_plugin_file_system;
      case "doc":
        return R.drawable.ch_plugin_file_word;
      case "text":
        return R.drawable.ch_plugin_file_document;
      case "key":
        return R.drawable.ch_plugin_file_keynote;
      case "hwp":
        return R.drawable.ch_plugin_file_hancom;
      case "data":
        return R.drawable.ch_plugin_file_data;
      case "xls":
        return R.drawable.ch_plugin_file_excel;
      case "numbers":
        return R.drawable.ch_plugin_file_numbers;
      case "ppt":
        return R.drawable.ch_plugin_file_powerpoint;
      case "pdf":
        return R.drawable.ch_plugin_file_pdf;
      case "pages":
        return R.drawable.ch_plugin_file_pages;
      case "audio":
        return R.drawable.ch_plugin_file_sound;
      case "video":
        return R.drawable.ch_plugin_file_video;
      case "psd":
        return R.drawable.ch_plugin_file_photoshop;
      case "ai":
        return R.drawable.ch_plugin_file_ai;
      case "sketch":
        return R.drawable.ch_plugin_file_sketchapp;
      case "font":
        return R.drawable.ch_plugin_file_font;
      case "vector":
        return R.drawable.ch_plugin_file_vector;
      case "zip":
        return R.drawable.ch_plugin_file_zip;
      default:
        return R.drawable.ch_plugin_file_else;
    }
  }

  public static String getString(Context context, String key) {
    try {
      if (key != null) {
        int resId = context.getResources().getIdentifier(key, "string", context.getPackageName());

        if (resId != 0) {
          String languageCode = PrefSupervisor.getPluginLanguage(context);
          if (languageCode != null) {
            Locale locale;
            switch (languageCode) {
              case "ko":
                locale = new Locale("ko");
                break;
              case "ja":
                locale = new Locale("ja");
                break;
              default:
                locale = new Locale("en");
                break;
            }
            return getLocaleStringResource(context, locale, resId);
          } else {
            return context.getResources().getString(resId);
          }
        }
      }
    } catch (Exception ex) {
    }

    return "???";
  }

  public static String getLocaleStringResource(Context context, Locale requestedLocale, int resourceId) {
    String result;
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) { // use latest api
      Configuration config = new Configuration(context.getResources().getConfiguration());
      config.setLocale(requestedLocale);
      result = context.createConfigurationContext(config).getText(resourceId).toString();
    } else { // support older android versions
      Resources resources = context.getResources();
      Configuration conf = resources.getConfiguration();
      Locale savedLocale = conf.locale;
      conf.locale = requestedLocale;
      resources.updateConfiguration(conf, null);

      // retrieve resources from desired locale
      result = resources.getString(resourceId);

      // restore original locale
      conf.locale = savedLocale;
      resources.updateConfiguration(conf, null);
    }

    return result;
  }
}
