package com.zoyi.channel.plugin.android.model.rest;

import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.model.Form;
import com.zoyi.channel.plugin.android.model.Submit;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.message_format.span.GiantEmojiSpan;

import java.util.List;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Message implements Entity {
  private String id;
  private String channelId;
  private String chatType;
  private String chatId;
  private String personType;
  private String personId;
  private String message;
  private String messageV2;
  private Long createdAt;
  private String requestId;
  private File file;
  private WebPage webPage;
  private Log log;
  private BotOption botOption;
  private SpannableStringBuilder formattedSpanMessage;
  private String formattedStringMessage;
  private List<ProfileBot> profileBot;
  private Form form;
  private Submit submit;
  private String language;

  public Message() {
  }

  public Message(String message, String personType, String personId, long createdAt) {
    this.message = message;
    this.personType = personType;
    this.personId = personId;
    this.createdAt = createdAt;
    this.formattedSpanMessage = ParseUtils.parseMessage(message);
    if (formattedSpanMessage != null) {
      this.formattedStringMessage = formattedSpanMessage.toString();
    }
  }

  @Override
  public String getId() {
    return id;
  }

  public String getChannelId() {
    return channelId;
  }

  public String getChatType() {
    return chatType;
  }

  public String getChatId() {
    return chatId;
  }

  public String getPersonType() {
    return personType;
  }

  public String getPersonId() {
    return personId;
  }

  public String getMessage() {
    if (messageV2 != null) {
      return messageV2;
    } else {
      return message;
    }
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public String getRequestId() {
    return requestId;
  }

  public File getFile() {
    return file;
  }

  public WebPage getWebPage() {
    return webPage;
  }

  public boolean hasContent() {
    return file != null || webPage != null;
  }

  public final static String CLASSNAME = "Message";

  public boolean isUserMessage() {
    return "User".equals(personType) || "Veil".equals(personType);
  }

  public Log getLog() {
    return log;
  }

  public void setBotOption(BotOption botOption) {
    this.botOption = botOption;
  }

  public BotOption getBotOption() {
    return botOption;
  }

  public SpannableStringBuilder getFormattedSpanMessage() {
    return formattedSpanMessage;
  }

  public String getFormattedStringMessage() {
    return formattedStringMessage;
  }

  public List<ProfileBot> getProfileBot() {
    return profileBot;
  }

  public Form getForm() {
    return form;
  }

  public Submit getSubmit() {
    return submit;
  }

  public void setFormattedSpanMessage(SpannableStringBuilder formattedSpanMessage) {
    this.formattedSpanMessage = formattedSpanMessage;
  }

  public void setFormattedStringMessage(String formattedStringMessage) {
    this.formattedStringMessage = formattedStringMessage;
  }

  public boolean hasOnlyEmoji() {
    return formattedSpanMessage != null
        && formattedSpanMessage.length() > 0
        && formattedSpanMessage.getSpans(0, formattedSpanMessage.length(), GiantEmojiSpan.class).length > 0;
  }

  public String getLanguage() {
    return language;
  }
}
