package com.zoyi.channel.plugin.android.activity.chat.type;

/**
 * Created by mika on 2016. 12. 8..
 */
public enum MessageType {
  ACTION_MESSAGE(0),
  DATE(5),
  NEW_MESSAGE_DIVIDER(6),
  SENDING(7),
  FETCH_FAILED(9),
  RESOLVE(11),
  CLOSE(12),
  LOG(13),
  TYPING(14),

  GUEST_TEXT_MESSAGE(20),
  GUEST_WEB_MESSAGE(21),
  GUEST_IMAGE_MESSAGE(22),
  GUEST_FILE_MESSAGE(23),
  MANAGER_TEXT_MESSAGE(30),
  MANAGER_WEB_MESSAGE(31),
  MANAGER_IMAGE_MESSAGE(32),
  MANAGER_FILE_MESSAGE(33),
  BOT_TEXT_MESSAGE(40),
  BOT_WEB_MESSAGE(41),
  BOT_IMAGE_MESSAGE(42),
  BOT_FILE_MESSAGE(43),
  PROFILE_BOT_MESSAGE(50),
  FORM_MESSAGE(51),

  WELCOME_MESSAGE(99),

  UNKNOWN(100);

  private final int value;
  MessageType(int value) {
    this.value = value;
  }

  public int toInt() {
    return value;
  }

  public static MessageType fromId(int id) {
    for (MessageType type : MessageType.values()) {
      if (type.toInt() == id) {
        return type;
      }
    }
    return UNKNOWN;
  }
}
