/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.animation.Animator;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.zoyi.channel.plugin.android.activity.chat.TopNavFragment;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TopNavBus;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimatorListener;

public class ChatRecyclerView
extends RecyclerView {
    public static final int DIRECTION_SCROLLING_DOWN = -1;
    @Nullable
    private TopNavFragment topNavFragment;
    @Nullable
    private String backwardId = "zzzzzzzzzzzzzzzz";
    private float firstY;
    private float lastDy = 0.0f;
    private float diff = 0.0f;
    private boolean handleScroll = false;
    private boolean scrolling = false;
    private boolean isAnimating = false;

    public ChatRecyclerView(Context context) {
        this(context, null);
    }

    public ChatRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChatRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setTopNavFragment(TopNavFragment topNavFragment) {
        this.topNavFragment = topNavFragment;
    }

    public void setBackwardId(@Nullable String backwardId) {
        this.backwardId = backwardId;
    }

    public boolean isScrolling() {
        return this.scrolling;
    }

    private boolean isTop() {
        return !this.canScrollVertically(-1) && TextUtils.isEmpty((CharSequence)this.backwardId);
    }

    public boolean onTouchEvent(MotionEvent e) {
        int TOP_NAV_HEIGHT;
        int n = TOP_NAV_HEIGHT = this.topNavFragment != null ? this.topNavFragment.getLayoutTopNav().getHeight() : 0;
        if (this.isAnimating) {
            return true;
        }
        switch (e.getActionMasked()) {
            case 0: {
                this.scrolling = true;
                this.firstY = e.getRawY();
                this.lastDy = 0.0f;
                this.handleScroll = false;
                break;
            }
            case 2: {
                float topNavTranslationY;
                float dy = e.getRawY() - this.firstY;
                this.diff = dy - this.lastDy;
                this.lastDy = dy;
                this.handleScroll = false;
                if (!this.isTop() || this.topNavFragment == null) break;
                float lastTopNavTranslationY = this.topNavFragment.getRoot().getTranslationY();
                float translationY = this.getTranslationY();
                if (this.diff > 0.0f) {
                    if (lastTopNavTranslationY == 0.0f) {
                        this.setTranslationY(Math.min(translationY + this.diff, (float)TOP_NAV_HEIGHT), false);
                        return true;
                    }
                    topNavTranslationY = Math.min(0.0f, lastTopNavTranslationY + this.diff);
                } else {
                    if (lastTopNavTranslationY == (float)(-TOP_NAV_HEIGHT)) {
                        return super.onTouchEvent(e);
                    }
                    if (lastTopNavTranslationY == 0.0f) {
                        if (translationY == 0.0f) {
                            return super.onTouchEvent(e);
                        }
                        if (translationY > 0.0f && translationY < (float)TOP_NAV_HEIGHT) {
                            this.setTranslationY(Math.max(translationY + this.diff, 0.0f), false);
                            return true;
                        }
                    }
                    topNavTranslationY = Math.max((float)(-TOP_NAV_HEIGHT), lastTopNavTranslationY + this.diff);
                }
                this.handleScroll = true;
                RxBus.post(new TopNavBus.TranslationY(topNavTranslationY));
                this.setTranslationY(topNavTranslationY + (float)TOP_NAV_HEIGHT, false);
                return true;
            }
            case 1: {
                if (this.handleScroll && this.isTop() && this.topNavFragment != null) {
                    float topNavY = this.topNavFragment.getRoot().getTranslationY();
                    if (topNavY > (float)(-TOP_NAV_HEIGHT / 2)) {
                        RxBus.post(new TopNavBus.Expand());
                        this.setTranslationY(TOP_NAV_HEIGHT, true);
                    } else {
                        RxBus.post(new TopNavBus.Collapse());
                        this.setTranslationY(0.0f, true);
                    }
                    return true;
                }
                this.scrolling = false;
            }
        }
        return super.onTouchEvent(e);
    }

    public void setTranslationY(float value, boolean animate) {
        boolean expand;
        boolean bl = expand = value > 0.0f;
        if (animate) {
            this.isAnimating = true;
            this.scrolling = true;
            this.animate().translationY(value).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    RxBus.post(new TopNavBus.Change(expand));
                    ChatRecyclerView.this.isAnimating = false;
                    ChatRecyclerView.this.scrolling = false;
                }
            }).start();
        } else {
            RxBus.post(new TopNavBus.Change(expand));
            super.setTranslationY(value);
        }
    }
}

