package com.zoyi.channel.plugin.android.util.draw;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.view.WindowManager;

public class Display {

  public static int getWidth(Context context) {
    if (context instanceof Activity) {
      return getWidth((Activity) context);
    }
    WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    android.view.Display display = wm.getDefaultDisplay();
    Point outSize = new Point();
    display.getSize(outSize);
    return outSize.x;
  }

  public static int getWidth(Activity activity) {
    DisplayMetrics metrics = new DisplayMetrics();
    activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);

    return metrics.widthPixels;
  }

  public static int getHeight(Context context) {
    if (context instanceof Activity) {
      return getHeight((Activity) context);
    }
    WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    android.view.Display display = wm.getDefaultDisplay();
    Point outSize = new Point();
    display.getSize(outSize);
    return outSize.y;
  }

  public static int getHeight(Activity activity) {
    DisplayMetrics metrics = new DisplayMetrics();
    activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);

    return metrics.heightPixels;
  }
}
