package com.zoyi.channel.plugin.android.activity.userchat_list.contract;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.base.BasePresenter;
import com.zoyi.channel.plugin.android.base.BaseView;

public interface UserChatListContract {

  interface View extends BaseView<Presenter> {

    void userChatsFetched(UserChatsWrapper userChatsWrapper, boolean init);
    void startChat(String chatId);
    void setErrorView(boolean show);
    void showDeleteUserChatDialog(String chatId);
    void completeRemoveChat();
    void successFetchPreloadData(String chatId, Transition transition);
  }

  interface Presenter extends BasePresenter<View> {

    void fetchPreloadData(@Nullable String chatId, Transition transition);
    void setAdapterView(UserChatAdapterContract.View adapterView);
    void setAdapterModel(UserChatAdapterContract.Model adapterModel);
    void refresh();
    void receiveCommand(Command command, @Nullable Object object);
    void receiveData(Entity entity, boolean upsert);
    void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity);
    void removeUserChat(String chatId);
    void redrawList();
  }
}
