package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.userchat_list.contract.UserChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.userchat_list.holder.UserChatHolder;
import com.zoyi.channel.plugin.android.activity.userchat_list.listener.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.UserChatItem;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.util.CompareUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by mika on 2016. 12. 6..
 */
class UserChatListAdapter
    extends RecyclerView.Adapter<UserChatHolder>
    implements UserChatAdapterContract.View, UserChatAdapterContract.Model {

  @Nullable
  private OnUserChatClickListener listener;

  private Map<String, UserChatItem> map;
  private SortedList<UserChatItem> items;

  UserChatListAdapter() {
    map = new HashMap<>();
    items = new SortedList<>(UserChatItem.class, new SortedListCallback<UserChatItem>(this, true));
  }

  @Override
  public void setOnUserChatClickListener(OnUserChatClickListener clickListener) {
    this.listener = clickListener;
  }

  @Override
  public void init(UserChatsWrapper repo) {
    clear();

    items.beginBatchedUpdates();
    for (UserChat userChat : repo.getUserChats()) {
      UserChatItem item = new UserChatItem(userChat);

      map.put(item.getId(), item);
      items.add(item);
    }
    items.endBatchedUpdates();
  }

  public void clear() {
    if (map != null) {
      map.clear();
    }
    if (items != null) {
      items.clear();
    }
  }

  private void updateItem(UserChatItem item) {
    int position = items.indexOf(item);

    if (position >= 0) {
      items.updateItemAt(position, item);
    }
  }

  @Override
  public void upsertUserChat(UserChat userChat) {
    if (userChat != null) {
      String chatId = userChat.getId();
      UserChatItem item;

      if (map.containsKey(chatId)) {
        item = map.get(chatId);
        item.setUserChat(userChat);

        updateItem(item);
      } else {
        item = new UserChatItem(userChat);

        map.put(item.getId(), item);
        items.add(item);
      }
    }
  }

  @Override
  public void removeUserChat(UserChat userChat) {
    if (userChat != null) {
      removeUserChat(userChat.getId());
    }
  }

  @Override
  public void removeUserChat(String chatId) {
    if (map.containsKey(chatId)) {
      items.remove(map.get(chatId));
      map.remove(chatId);
    }
  }

  @Override
  public UserChatHolder onCreateViewHolder(ViewGroup parent, int viewType) {
    return UserChatHolder.newInstance(parent, listener);
  }

  @Override
  public void onBindViewHolder(UserChatHolder holder, int position) {
    holder.setUserChatItem(items.get(position));
  }

  @Override
  public int getItemCount() {
    return items.size();
  }

  @Nullable
  public String getChatId(int position) {
    if (items.size() <= position) {
      return null;
    }
    return items.get(position).getId();
  }

  @Override
  public void updateManager(String managerId) {
    for (int i = 0; i < items.size(); i++) {
      UserChatItem item = items.get(i);

      if (CompareUtils.isSame(item.getHostType(), Const.MANAGER) && CompareUtils.isSame(item.getHostId(), managerId)) {
        items.updateItemAt(i, item);
      }
    }
  }

  @Override
  public void updateSession(Session session) {
    if (session != null) {
      for (int i = 0; i < items.size(); i++) {
        UserChatItem item = items.get(i);

        if (CompareUtils.isSame(item.getId(), session.getId())) {
          items.updateItemAt(i, item);
          break;
        }
      }
    }
  }
}
