package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;

/**
 * Created by mika on 2018. 4. 17..
 */

public class ProfileBotMessageItem implements MessageItem {

  private Message message;

  @Nullable
  private String inputKey;
  @Nullable
  private Object inputState;
  @Nullable
  private String inputError;

  private boolean inputLoading;
  private boolean lastProfileTyping;

  public ProfileBotMessageItem(Message message) {
    this.message = message;
    this.inputKey = "";
    this.inputState = "";
    this.inputLoading = false;
    this.inputError = "";
    this.lastProfileTyping = false;
  }

  @Override
  public Long getPrimaryKey() {
    return message.getCreatedAt() + 1;
  }

  @Override
  public String getSecondaryKey() {
    return "ProfileBot";
  }

  @Override
  public MessageType getType() {
    return MessageType.PROFILE_BOT_MESSAGE;
  }

  public Message getMessage() {
    return message;
  }

  @Nullable
  public String getInputKey() {
    return inputKey;
  }

  @Nullable
  public Object getInputState() {
    return inputState;
  }

  public boolean isInputLoading() {
    return inputLoading;
  }

  @Nullable
  public String getInputError() {
    return inputError;
  }

  public boolean isLastProfileTyping() {
    return lastProfileTyping;
  }

  public void setLastProfileTypingState(boolean lastProfileTyping) {
    this.lastProfileTyping = lastProfileTyping;
  }

  public void setInputState(@Nullable String inputKey, @Nullable Object inputState, boolean inputLoading, @Nullable String inputError) {
    this.inputKey = inputKey;
    this.inputState = inputState;
    this.inputLoading = inputLoading;
    this.inputError = inputError;
  }

  public void setInputState(@Nullable Object inputState) {
    this.inputState = inputState;
  }

  public void resetInputState() {
    this.inputKey = "";
    this.inputState = "";
    this.inputLoading = false;
    this.inputError = "";
  }

  public void setMessage(Message message) {
    this.message = message;
  }
}
