package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.model.rest.Message;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jerry on 2018. 6. 11..
 */

public class FormMessageItem implements MessageItem {

  private Message message;

  @Nullable
  private List<ActionInput> actionInputs;

  @Nullable
  private String type;

  public FormMessageItem(Message message) {
    this.message = message;

    if (message.getForm() != null) {
      this.type = message.getForm().getType();
      this.actionInputs = message.getForm().getInputs();

      for (ActionInput actionInput : actionInputs) {
        actionInput.setMessageId(message);
      }
    }
  }

  @Nullable
  public String getActionType() {
    return type;
  }

  @Nullable
  public List<ActionInput> getActionInputs() {
      return actionInputs;
  }

  @Override
  public MessageType getType() {
    return MessageType.FORM_MESSAGE;
  }

  public Long getCreatedAt() {
    return message.getCreatedAt();
  }

  @Override
  public Long getPrimaryKey() {
    return message.getCreatedAt() + 3;
  }

  @Override
  public String getSecondaryKey() {
    return this.getClass().getCanonicalName();
  }
}
