package com.zoyi.channel.plugin.android.model.wrapper;

import com.zoyi.channel.plugin.android.store.*;

public class ChatPreloadWrapper extends BaseRepo {

  private ManagersWrapper managersWrapper;
  private PluginWrapper pluginWrapper;

  public ChatPreloadWrapper(ManagersWrapper managersWrapper, PluginWrapper pluginWrapper) {
    this.managersWrapper = managersWrapper;
    this.pluginWrapper = pluginWrapper;
  }

  @Override
  public void update() {
    if (managersWrapper != null) {
      managersWrapper.update();
      managersWrapper.setFollowingManagers();
    }
    if (pluginWrapper != null) {
      Store.getInstance(PluginStore.class).update(pluginWrapper.getPlugin());
      Store.getInstance(ChannelStore.class).update(pluginWrapper.getChannel());
      Store.getInstance(UserStore.class).update(pluginWrapper.getUser());
      Store.getInstance(VeilStore.class).update(pluginWrapper.getVeil());
      Store.getInstance(BotStore.class).add(pluginWrapper.getBot());
      Store.getInstance(BotStore.class).setDefaultBot(pluginWrapper.getBot());
    }
  }
}
