package com.zoyi.channel.plugin.android.util.message_format.message;

import android.graphics.Typeface;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;

import com.zoyi.channel.plugin.android.util.L;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class BoldMessage implements MessagePattern {

  private Pattern boldPattern = Pattern.compile("(\\*\\*)(.+?)\\1");

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {
    Matcher matcher = boldPattern.matcher(span);

    while (matcher.find()) {
      try {
        int start = matcher.start();
        int end = matcher.end();

        span.delete(end - 2, end);
        span.delete(start, start + 2);
        span.setSpan(
            new StyleSpan(Typeface.BOLD),
            start,
            end - 4,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);

        matcher = boldPattern.matcher(span);
      } catch (IndexOutOfBoundsException indexException) {
        L.e(indexException.getMessage());
        return span;
      }
    }

    return span;
  }
}
