/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.webview.CHWebViewActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import java.io.Serializable;

public class IntentUtils {
    @Nullable
    private Context context;
    @Nullable
    private Intent intent;
    private Transition transition = Transition.SLIDE_FROM_RIGHT;

    public static IntentUtils setNextActivity(@Nullable Context context, @Nullable Class<?> clazz) {
        IntentUtils intentUtils = new IntentUtils();
        intentUtils.context = context;
        intentUtils.intent = new Intent(context, clazz);
        return intentUtils;
    }

    public IntentUtils() {
    }

    private IntentUtils(@Nullable Context context, @Nullable Intent intent) {
        this.context = context;
        this.intent = intent;
    }

    public IntentUtils putExtra(String key, @Nullable Integer value) {
        if (this.intent != null && value != null) {
            this.intent.putExtra(key, (Serializable)value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, @Nullable Long value) {
        if (this.intent != null && value != null) {
            this.intent.putExtra(key, (Serializable)value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, @Nullable String value) {
        if (this.intent != null && value != null) {
            this.intent.putExtra(key, value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, @Nullable Boolean value) {
        if (this.intent != null && value != null) {
            this.intent.putExtra(key, (Serializable)value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, @Nullable Parcelable value) {
        if (this.intent != null && value != null) {
            this.intent.putExtra(key, value);
        }
        return this;
    }

    public IntentUtils setTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    public void startActivity() {
        if (this.context != null && this.intent != null) {
            try {
                this.context.startActivity(this.intent);
                if (this.context instanceof Activity) {
                    this.setActivityTransition((Activity)this.context);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void startActivityForResult(int requestCode) {
        if (this.context instanceof Activity && this.intent != null) {
            this.intent.putExtra("REQUEST_CODE_INTENT_KEY", requestCode);
            ((Activity)this.context).startActivityForResult(this.intent, requestCode);
            this.setActivityTransition((Activity)this.context);
        }
    }

    private void setActivityTransition(Activity activity) {
        switch (this.transition) {
            case NONE: {
                activity.overridePendingTransition(R.anim.ch_plugin_idle, R.anim.ch_plugin_idle);
                break;
            }
            case SLIDE_FROM_RIGHT: {
                activity.overridePendingTransition(R.anim.ch_plugin_slide_in_right, R.anim.ch_plugin_idle);
                break;
            }
            case SLIDE_FROM_BOTTOM: {
                activity.overridePendingTransition(R.anim.ch_plugin_slide_in_bottom, R.anim.ch_plugin_idle);
            }
        }
    }

    public static IntentUtils setUrl(Context context, String url) {
        return IntentUtils.setNextActivity(context, CHWebViewActivity.class).putExtra("url", url);
    }

    public static IntentUtils setEmail(Context context, String email) {
        Uri uri;
        try {
            uri = Uri.parse((String)String.format("mailto:%s", email));
        }
        catch (Exception ignored) {
            return new IntentUtils(context, null);
        }
        return new IntentUtils(context, new Intent("android.intent.action.SENDTO", uri));
    }

    public static IntentUtils setPhone(Context context, String phoneNumber) {
        Uri uri;
        try {
            uri = Uri.parse((String)String.format("tel:%s", phoneNumber));
        }
        catch (Exception ignored) {
            return new IntentUtils(context, null);
        }
        return new IntentUtils(context, new Intent("android.intent.action.CALL", uri));
    }
}

