/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.store;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.StoreBus;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.store.Store;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CollectionStore<E extends Entity>
extends Store {
    protected Map<String, E> map = new HashMap<String, E>();

    protected boolean canUpdate(E oldbie, E newbie) {
        return true;
    }

    @Nullable
    public synchronized E get(@Nullable String id2) {
        if (id2 == null) {
            return null;
        }
        return (E)((Entity)this.map.get(id2));
    }

    public synchronized List<E> get() {
        return new ArrayList<E>(this.map.values());
    }

    public synchronized void set(Collection<E> list) {
        this.map.clear();
        this.add(list);
    }

    private boolean upsert(E e) {
        if (e != null && (this.map.get(e.getId()) == null || this.canUpdate((Entity)this.map.get(e.getId()), e))) {
            this.map.put(e.getId(), e);
            return true;
        }
        return false;
    }

    public synchronized void add(E e) {
        if (this.upsert(e)) {
            this.updated(e);
        }
    }

    public synchronized void add(@Nullable Collection<E> list) {
        if (list != null) {
            for (Entity e : list) {
                this.upsert(e);
            }
        }
        RxBus.post(new StoreBus(this.getStoreType()));
    }

    public synchronized void remove(@Nullable E e) {
        Entity item;
        if (e != null && e.getId() != null && (item = (Entity)this.map.remove(e.getId())) != null) {
            this.removed(e);
        }
    }

    public synchronized int size() {
        return this.map.size();
    }

    protected void updated(E e) {
        RxBus.post(new StoreBus<E>(this.getStoreType(), UpdateType.UPDATE, e));
    }

    protected void removed(E e) {
        RxBus.post(new StoreBus<E>(this.getStoreType(), UpdateType.DELETE, e));
    }
}

