/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.model.Form;
import com.zoyi.channel.plugin.android.model.Submit;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.rest.BotOption;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Log;
import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.message_format.span.GiantEmojiSpan;
import java.util.List;

public class Message
implements Entity {
    private String id;
    private String channelId;
    private String chatType;
    private String chatId;
    private String personType;
    private String personId;
    private String message;
    private String messageV2;
    private Long createdAt;
    private String requestId;
    private File file;
    private WebPage webPage;
    private Log log;
    private BotOption botOption;
    private SpannableStringBuilder formattedSpanMessage;
    private String formattedStringMessage;
    private List<ProfileBot> profileBot;
    private Form form;
    private Submit submit;
    private String language;
    public static final String CLASSNAME = "Message";

    public Message() {
    }

    public Message(String message, String personType, String personId, long createdAt) {
        this.message = message;
        this.personType = personType;
        this.personId = personId;
        this.createdAt = createdAt;
        this.formattedSpanMessage = ParseUtils.parseMessage(message);
        if (this.formattedSpanMessage != null) {
            this.formattedStringMessage = this.formattedSpanMessage.toString();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getChatType() {
        return this.chatType;
    }

    public String getChatId() {
        return this.chatId;
    }

    public String getPersonType() {
        return this.personType;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getMessage() {
        if (this.messageV2 != null) {
            return this.messageV2;
        }
        return this.message;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public File getFile() {
        return this.file;
    }

    public WebPage getWebPage() {
        return this.webPage;
    }

    public boolean hasContent() {
        return this.file != null || this.webPage != null;
    }

    public boolean isUserMessage() {
        return "User".equals(this.personType) || "Veil".equals(this.personType);
    }

    public Log getLog() {
        return this.log;
    }

    public void setBotOption(BotOption botOption) {
        this.botOption = botOption;
    }

    public BotOption getBotOption() {
        return this.botOption;
    }

    public SpannableStringBuilder getFormattedSpanMessage() {
        return this.formattedSpanMessage;
    }

    public String getFormattedStringMessage() {
        return this.formattedStringMessage;
    }

    public List<ProfileBot> getProfileBot() {
        return this.profileBot;
    }

    public Form getForm() {
        return this.form;
    }

    public Submit getSubmit() {
        return this.submit;
    }

    public void setFormattedSpanMessage(SpannableStringBuilder formattedSpanMessage) {
        this.formattedSpanMessage = formattedSpanMessage;
    }

    public void setFormattedStringMessage(String formattedStringMessage) {
        this.formattedStringMessage = formattedStringMessage;
    }

    public void clearForm() {
        this.form = null;
    }

    public boolean hasOnlyEmoji() {
        return this.formattedSpanMessage != null && this.formattedSpanMessage.length() > 0 && ((GiantEmojiSpan[])this.formattedSpanMessage.getSpans(0, this.formattedSpanMessage.length(), GiantEmojiSpan.class)).length > 0;
    }

    public String getLanguage() {
        return this.language;
    }
}

