/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.OnGuestUpdatedListener;
import com.zoyi.channel.plugin.android.event.BadgeBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.PushBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;

public class ChannelIOManager {
    @Nullable
    private static ChannelIOManager channelIOManager;
    private Application application;
    private int activityRunningCount = 0;
    @Nullable
    private Subscription socketSubscription;
    @Nullable
    private ChannelPluginListener channelPluginListener;

    static void create(Application application) {
        if (channelIOManager == null) {
            channelIOManager = new ChannelIOManager(application);
        }
    }

    private ChannelIOManager(Application application) {
        this.application = application;
    }

    static void bootPlugin(PluginWrapper pluginWrapper) {
        if (channelIOManager != null) {
            channelIOManager.startReceiveSocket();
        }
    }

    static void clear() {
        if (channelIOManager != null) {
            channelIOManager.stopReceiveSocket();
        }
    }

    static void fetchMe(final @Nullable OnGuestUpdatedListener listener) {
        if (channelIOManager != null) {
            ChannelApiManager.get().touch().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<GuestWrapper>(){

                @Override
                public void onNext(GuestWrapper repo) {
                    if (repo != null) {
                        repo.update();
                        if (listener != null) {
                            listener.onGuestUpdated();
                        }
                    }
                }
            });
        }
    }

    private void startReceiveSocket() {
        if (this.socketSubscription == null || this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription = RxBus.observable().subscribe((Action1)new Action1<Object>(){

                public void call(Object o) {
                    if (o instanceof CommandBus) {
                        CommandBus commandBus = (CommandBus)o;
                        switch (commandBus.getCommand()) {
                            case READY: {
                                ChannelIOManager.fetchMe(null);
                            }
                        }
                    }
                    if (o instanceof BadgeBus && ChannelIOManager.this.channelPluginListener != null) {
                        ChannelIOManager.this.channelPluginListener.onChangeBadge(((BadgeBus)o).getCount());
                    }
                    if (o instanceof PushBus) {
                        PushBus pushBus = (PushBus)o;
                        if (ChannelIOManager.this.channelPluginListener != null) {
                            ChannelIOManager.this.channelPluginListener.onReceivePush(new PushEvent(pushBus));
                        }
                    }
                }
            });
        }
    }

    private void stopReceiveSocket() {
        if (this.socketSubscription != null && !this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription.unsubscribe();
        }
    }

    public static void increaseActivityRunningCount() {
        if (channelIOManager != null) {
            ++ChannelIOManager.channelIOManager.activityRunningCount;
        }
    }

    public static void decreaseActivityRunningCount() {
        if (channelIOManager != null) {
            --ChannelIOManager.channelIOManager.activityRunningCount;
        }
    }

    public static boolean isChannelIOActivityRunning() {
        return channelIOManager != null && ChannelIOManager.channelIOManager.activityRunningCount > 0;
    }

    @Nullable
    public static ChannelPluginListener getChannelPluginListener() {
        if (channelIOManager != null) {
            return ChannelIOManager.channelIOManager.channelPluginListener;
        }
        return null;
    }

    static void setChannelPluginListener(ChannelPluginListener channelPluginListener) {
        if (channelIOManager != null) {
            ChannelIOManager.channelIOManager.channelPluginListener = channelPluginListener;
        }
    }

    static void clearChannelPluginListener() {
        if (channelIOManager != null) {
            ChannelIOManager.channelIOManager.channelPluginListener = null;
        }
    }
}

