/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.event.LanguageBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;

public class CHTextView
extends AppCompatTextView {
    private Context context;
    @Nullable
    private String textKey;
    @Nullable
    private Subscription subscription;
    private boolean isHTMLText;

    public CHTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CHTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CHTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        this.subscribe();
        this.setTypeArray(attrs);
    }

    private void setTypeArray(@Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChannelCustomView);
            this.textKey = typedArray.getString(R.styleable.ChannelCustomView_ch_text_key);
            this.isHTMLText = typedArray.getBoolean(R.styleable.ChannelCustomView_ch_html_text, false);
            this.setTextByKey(this.textKey);
        }
    }

    private void subscribe() {
        this.subscription = RxBus.observable().subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                CHTextView.this.onReceiveEvent(o);
            }
        });
    }

    private void onReceiveEvent(Object object) {
        if (object instanceof LanguageBus && this.textKey != null) {
            this.setTextByKey(this.textKey);
        }
    }

    public void setTextByKey(@Nullable String key) {
        this.textKey = key;
        if (this.isHTMLText && key != null) {
            super.setText((CharSequence)Utils.getHtmlFormattedText(ResUtils.getString(this.context, key)));
        } else {
            super.setText((CharSequence)ResUtils.getString(this.context, key));
        }
    }

    public void setTextByKey(@Nullable String key, @ColorRes int colorId) {
        this.setTextByKey(key);
        this.setTextColor(ContextCompat.getColor((Context)this.context, (int)colorId));
    }

    public void setText(String text, @ColorRes int colorId) {
        super.setText((CharSequence)text);
        this.setTextColor(ContextCompat.getColor((Context)this.context, (int)colorId));
    }

    protected void onDetachedFromWindow() {
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        super.onDetachedFromWindow();
    }
}

