package com.zoyi.channel.plugin.android.store;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.model.rest.Plugin;

/**
 * Created by mika on 2018. 6. 18..
 */

public class PluginStore extends SingleStore<Plugin> {

  private String pluginKey;

  @Override
  public void set(Plugin plugin) {
    super.set(plugin);

    if (plugin != null) {
      this.pluginKey = plugin.getKey();
    }
  }

  @Override
  protected boolean canUpdate(Plugin plugin) {
    return pluginKey != null && pluginKey.equals(plugin.getKey());
  }

  public void clearData() {
    super.clearData();

    this.pluginKey = null;
  }

  @Override
  protected StoreType getStoreType() {
    return StoreType.PLUGIN;
  }
}
