/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import android.content.SharedPreferences;
import com.splunk.mint.Properties;
import com.splunk.mint.SequentialExecutor;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class LastPing {
    protected static final String LASTPINGTIME = "LASTPINGTIME";
    private static final SequentialExecutor executor = new SequentialExecutor();
    private static final String forceSendPingFile = ".setForceSendPingOnNextStart";

    LastPing() {
    }

    protected static boolean shouldSendPing(Context ctx) {
        SharedPreferences preferences;
        Future<Boolean> future = executor.getExecutor().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                File forcePingfile = new File(Properties.FILES_PATH + "/" + LastPing.forceSendPingFile);
                if (forcePingfile != null && forcePingfile.exists()) {
                    forcePingfile.delete();
                    return true;
                }
                return false;
            }
        });
        Boolean result = false;
        try {
            result = future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (result.booleanValue()) {
            return result;
        }
        boolean shouldSendPing = true;
        if (ctx != null && (preferences = ctx.getSharedPreferences("Mint", 0)) != null) {
            long minSessionTimeInMiliseconds;
            long lastPing = preferences.getLong(LASTPINGTIME, 0L);
            long timeNow = System.currentTimeMillis();
            boolean bl = shouldSendPing = timeNow - lastPing > (minSessionTimeInMiliseconds = (long)(Properties.RemoteSettingsProps.sessionTime * 1000));
            if (shouldSendPing) {
                LastPing.setLastPingSentTime(ctx);
            }
            return shouldSendPing;
        }
        return shouldSendPing;
    }

    protected static void setForceSendPingOnNextStart() {
        executor.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                File file = new File(Properties.FILES_PATH + "/" + LastPing.forceSendPingFile);
                if (file != null && !file.exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    protected static synchronized void setLastPingSentTime(Context ctx) {
        SharedPreferences preferences;
        if (ctx != null && (preferences = ctx.getSharedPreferences("Mint", 0)) != null) {
            preferences.edit().putLong(LASTPINGTIME, System.currentTimeMillis()).apply();
        }
    }

    protected static synchronized long getLastPingSentTime(Context ctx) {
        SharedPreferences preferences;
        if (ctx != null && (preferences = ctx.getSharedPreferences("Mint", 0)) != null) {
            return preferences.getLong(LASTPINGTIME, 0L);
        }
        return 0L;
    }

    protected static synchronized void clearLastPingSentTime(Context ctx) {
        SharedPreferences preferences;
        if (ctx != null && (preferences = ctx.getSharedPreferences("Mint", 0)) != null) {
            preferences.edit().putLong(LASTPINGTIME, 0L).apply();
        }
    }
}

