/*
 * Decompiled with CFR 0.152.
 */
package com.github.anrwatchdog;

import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.github.anrwatchdog.ANRError;

public class ANRWatchDog
extends Thread {
    private static final int DEFAULT_ANR_TIMEOUT = 5000;
    private static final ANRListener DEFAULT_ANR_LISTENER = new ANRListener(){

        @Override
        public void onAppNotResponding(ANRError error) {
            throw error;
        }
    };
    private static final InterruptionListener DEFAULT_INTERRUPTION_LISTENER = new InterruptionListener(){

        @Override
        public void onInterrupted(InterruptedException exception) {
            Log.w((String)"ANRWatchdog", (String)("Interrupted: " + exception.getMessage()));
        }
    };
    private ANRListener _anrListener = DEFAULT_ANR_LISTENER;
    private InterruptionListener _interruptionListener = DEFAULT_INTERRUPTION_LISTENER;
    private final Handler _uiHandler = new Handler(Looper.getMainLooper());
    private final int _timeoutInterval;
    private String _namePrefix = "";
    private boolean _logThreadsWithoutStackTrace = false;
    private boolean _ignoreDebugger = false;
    private volatile int _tick = 0;
    private final Runnable _ticker = new Runnable(){

        @Override
        public void run() {
            ANRWatchDog.this._tick = (ANRWatchDog.this._tick + 1) % Integer.MAX_VALUE;
        }
    };

    public ANRWatchDog() {
        this(5000);
    }

    public ANRWatchDog(int timeoutInterval) {
        this._timeoutInterval = timeoutInterval;
    }

    public ANRWatchDog setANRListener(ANRListener listener) {
        this._anrListener = listener == null ? DEFAULT_ANR_LISTENER : listener;
        return this;
    }

    public ANRWatchDog setInterruptionListener(InterruptionListener listener) {
        this._interruptionListener = listener == null ? DEFAULT_INTERRUPTION_LISTENER : listener;
        return this;
    }

    public ANRWatchDog setReportThreadNamePrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this._namePrefix = prefix;
        return this;
    }

    public ANRWatchDog setReportMainThreadOnly() {
        this._namePrefix = null;
        return this;
    }

    public ANRWatchDog setLogThreadsWithoutStackTrace(boolean logThreadsWithoutStackTrace) {
        this._logThreadsWithoutStackTrace = logThreadsWithoutStackTrace;
        return this;
    }

    public ANRWatchDog setIgnoreDebugger(boolean ignoreDebugger) {
        this._ignoreDebugger = ignoreDebugger;
        return this;
    }

    @Override
    public void run() {
        this.setName("|ANR-WatchDog|");
        int lastIgnored = -1;
        while (!this.isInterrupted()) {
            int lastTick = this._tick;
            this._uiHandler.post(this._ticker);
            try {
                Thread.sleep(this._timeoutInterval);
            }
            catch (InterruptedException e) {
                this._interruptionListener.onInterrupted(e);
                return;
            }
            if (this._tick != lastTick) continue;
            if (!this._ignoreDebugger && Debug.isDebuggerConnected()) {
                if (this._tick != lastIgnored) {
                    Log.w((String)"ANRWatchdog", (String)"An ANR was detected but ignored because the debugger is connected (you can prevent this with setIgnoreDebugger(true))");
                }
                lastIgnored = this._tick;
                continue;
            }
            ANRError error = this._namePrefix != null ? ANRError.New(this._namePrefix, this._logThreadsWithoutStackTrace) : ANRError.NewMainOnly();
            this._anrListener.onAppNotResponding(error);
            return;
        }
    }

    public static interface InterruptionListener {
        public void onInterrupted(InterruptedException var1);
    }

    public static interface ANRListener {
        public void onAppNotResponding(ANRError var1);
    }
}

