package com.zoyi.channel.plugin.android.model.rest;

import android.text.TextUtils;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.RecordUpdatesEntity;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChat implements Entity, RecordUpdatesEntity {
  private String id;
  private String channelId;
  private String personType;
  private String personId;
  private String state;
  private Long createdAt;
  private Long appUpdatedAt;
  private Long resolvedAt;
  private String appMessageId;
  private String hostId;
  private String hostType;
  private String review;

  @Override
  public String getId() {
    return id;
  }

  public String getChannelId() {
    return channelId;
  }

  public String getPersonType() {
    return personType;
  }

  public String getPersonId() {
    return personId;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public boolean isStateReady() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_READY.equals(state);
  }

  public boolean isStateOpen() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_OPEN.equals(state);
  }

  public boolean isStateFollowing() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_FOLLOWING.equals(state);
  }

  public boolean isStateResolved() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_RESOLVED.equals(state);
  }

  public boolean isStateClosed() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_CLOSED.equals(state);
  }

  public boolean isStateCompleted() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_COMPLETED.contains(state);
  }

  public boolean isStateRemoved() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_REMOVED.equals(state);
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  @Override
  public Long getUpdatedAt() {
    return appUpdatedAt;
  }

  public String getLastMessageId() {
    return appMessageId;
  }

  public String getHostId() {
    return hostId;
  }

  public String getHostType() {
    return hostType;
  }

  public String getReview() {
    return review;
  }

  public Long getResolvedAt() {
    return resolvedAt;
  }

  public final static String CLASSNAME = "UserChat";
}
