package com.zoyi.channel.plugin.android.activity.userchat_list.contract;

import com.zoyi.channel.plugin.android.activity.userchat_list.listener.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.UserChatItem;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;

public interface UserChatAdapterContract {

  interface View {

    void setOnUserChatClickListener(OnUserChatClickListener clickListener);

    void removeUserChat(String chatId);
    void notifyDataSetChanged();
  }

  interface Model {

    void init(UserChatsWrapper wrapper);

    void removeUserChat(UserChat userChat);
    void upsertUserChat(UserChat userChat);

    void updateManager(String managerId);
    void updateSession(Session session);
  }

}
