package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.TypingItem;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.com.bumptech.glide.Glide;

import java.util.List;
import java.util.Locale;

public class TypingHolder extends RecyclerView.ViewHolder {

  public static TypingHolder newInstance(ViewGroup parent) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());
    View itemView = inflater.inflate(R.layout.ch_plugin_item_message_typing, parent, false);
    return new TypingHolder(itemView);
  }

  private AvatarLayout firstAvatar;
  private AvatarLayout secondAvatar;
  private AvatarLayout thirdAvatar;
  private CHTextView textCount;
  private ImageView imageTyping;
  private View root;

  private Context context;

  public TypingHolder(View itemView) {
    super(itemView);
    context = itemView.getContext();

    root = itemView.findViewById(R.id.ch_plugin_layout_typing_root);
    firstAvatar = (AvatarLayout) itemView.findViewById(R.id.ch_plugin_avatar_first);
    secondAvatar = (AvatarLayout) itemView.findViewById(R.id.ch_plugin_avatar_second);
    thirdAvatar = (AvatarLayout) itemView.findViewById(R.id.ch_plugin_avatar_third);
    textCount =  itemView.findViewById(R.id.ch_plugin_tv_person_count);
    imageTyping = (ImageView) itemView.findViewById(R.id.ch_plugin_iv_typing);
  }

  public void bind(TypingItem item) {
    if (item.hasTyping()) {
      root.setVisibility(View.VISIBLE);

      Glide.with(context).load(R.drawable.ch_plugin_typing).asGif().into(imageTyping);
      List<Typing> typings = item.getTypings();

      if (item.hasMoreThanFour()) {
        secondAvatar.setVisibility(View.VISIBLE);
        thirdAvatar.setVisibility(View.GONE);
        textCount.setVisibility(View.VISIBLE);

        firstAvatar.set(typings.get(0).getProfileEntity());
        secondAvatar.set(typings.get(1).getProfileEntity());
        textCount.setText(String.format(Locale.US, "+%d", typings.size() - 2));
      } else {
        textCount.setVisibility(View.GONE);

        int size = typings.size();
        if (size <= 0) {
          return;
        }

        firstAvatar.set(typings.get(0).getProfileEntity());
        switch (size) {
          case 1:
            secondAvatar.setVisibility(View.GONE);
            thirdAvatar.setVisibility(View.GONE);
            break;

          case 2:
            secondAvatar.set(typings.get(1).getProfileEntity());
            secondAvatar.setVisibility(View.VISIBLE);
            thirdAvatar.setVisibility(View.GONE);
            break;

          case 3:
            secondAvatar.set(typings.get(1).getProfileEntity());
            thirdAvatar.set(typings.get(2).getProfileEntity());
            secondAvatar.setVisibility(View.VISIBLE);
            thirdAvatar.setVisibility(View.VISIBLE);
            break;
        }
      }
    } else {
      root.setVisibility(View.INVISIBLE);
    }
  }
}
