package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnTextMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.TranslationInfo;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.TranslationSelector;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.message_format.CustomMovementMethod;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

/**
 * Created by jerry on 2018. 3. 30..
 */

public class TextMessageHolder extends BaseMessageHolder {

  @Nullable
  protected MaskableFrameLayout guestMessageHeadLayout;
  @Nullable
  protected MaskableFrameLayout guestMessageContentLayout;
  @Nullable
  protected CHTextView guestMessageText;
  @Nullable
  protected View guestMessageTopView;
  @Nullable
  protected View guestMessageContentView;

  @Nullable
  protected View managerMessageHeadTop;
  @Nullable
  protected View managerMessageContextTop;
  @Nullable
  protected CHTextView managerMessageText;

  @Nullable
  private TextView giantEmojiText;

  @Nullable
  private View hostMessageTranslationLayout;

  @Nullable
  private LinearLayout translationButtonLayout;
  @Nullable
  private CHTextView translationButton;
  @Nullable
  private ImageView translationButtonArrow;
  @Nullable
  private CircularProgressView translationProgressView;

  @Nullable
  private Message message;

  @Nullable
  private OnTextMessageClickListener listener;

  public static TextMessageHolder newInstance(ViewGroup parent, MessageType messageType, @Nullable OnTextMessageClickListener listener) {
    return new TextMessageHolder(getItemView(parent, messageType), messageType, listener);
  }

  public TextMessageHolder(View itemView, MessageType messageType, @Nullable OnTextMessageClickListener listener) {
    super(itemView, messageType);
    this.listener = listener;

    switch (messageType) {
      case GUEST_TEXT_MESSAGE:
      case GUEST_IMAGE_MESSAGE:
      case GUEST_FILE_MESSAGE:
      case GUEST_WEB_MESSAGE:
        guestMessageHeadLayout = itemView.findViewById(R.id.ch_layout_guest_message_head);
        guestMessageContentLayout = itemView.findViewById(R.id.ch_layout_guest_message_content);
        guestMessageText = itemView.findViewById(R.id.ch_text_guest_message);
        guestMessageTopView = itemView.findViewById(R.id.ch_view_guest_message_head_top);
        guestMessageContentView = itemView.findViewById(R.id.ch_view_guest_message_content_top);
        giantEmojiText = itemView.findViewById(R.id.ch_message_content_giant_emoji);
        break;

      default:
        managerMessageHeadTop = itemView.findViewById(R.id.ch_view_manager_message_head_top);
        managerMessageContextTop = itemView.findViewById(R.id.ch_view_manager_message_context_top);
        managerMessageText = itemView.findViewById(R.id.ch_text_manager_message);
        giantEmojiText = itemView.findViewById(R.id.ch_message_content_giant_emoji);
        hostMessageTranslationLayout = itemView.findViewById(R.id.ch_message_content_translate);
        translationButtonLayout = itemView.findViewById(R.id.ch_layout_translate_button);
        translationButton = itemView.findViewById(R.id.ch_text_host_message_translate);
        translationButtonArrow = itemView.findViewById(R.id.ch_img_host_message_translate_arrow);
        translationProgressView = itemView.findViewById(R.id.ch_progress_host_message_translate);
        setTranslationButtonClickListener();
        break;
    }
  }

  public void bind(ChatMessageItem item, boolean isConnectedMessage) {
    super.bind(item.getMessage(), item.getType(), isConnectedMessage);
    message = item.getMessage();

    switch (item.getType()) {
      case GUEST_TEXT_MESSAGE:
      case GUEST_IMAGE_MESSAGE:
      case GUEST_FILE_MESSAGE:
      case GUEST_WEB_MESSAGE:
        setGuestMessageText(item, isConnectedMessage);
        break;

      default:
        setManagerMessageText(item, isConnectedMessage);
        break;
    }
  }

  private void setGuestMessageText(ChatMessageItem item, boolean isConnectedMessage) {
    if (item.getMessage() == null) {
      return;
    }

    if (item.getMessage().hasOnlyEmoji()) {
      setGiantEmoji(item.getMessage());
    } else if (item.getMessage().getMessage() != null &&
        guestMessageTextLayout != null &&
        guestMessageHeadLayout != null &&
        guestMessageContentLayout != null &&
        guestMessageText != null &&
        guestMessageTopView != null &&
        guestMessageContentView != null) {
      guestMessageTextLayout.setVisibility(View.VISIBLE);
      guestMessageHeadLayout.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
      guestMessageContentLayout.setVisibility(UIUtils.getVisible(isConnectedMessage, true));

      guestMessageTopView.setBackgroundColor(ColorSelector.getBackgroundColor());
      guestMessageContentView.setBackgroundColor(ColorSelector.getBackgroundColor());

      guestMessageText.setBackgroundColor(ColorSelector.getBackgroundColor());
      guestMessageText.setMovementMethod(CustomMovementMethod.getInstance());
      guestMessageText.setLinkTextColor(ColorSelector.getTextColor());
      guestMessageText.setTextColor(ColorSelector.getTextColor());
      guestMessageText.setText(message.getFormattedSpanMessage());
    }
  }

  // TODO : ManagerMessage -> HostMessage 로 이름 변경할 것
  private void setManagerMessageText(ChatMessageItem item, boolean isConnectedMessage) {
    if (item.getMessage() == null) {
      return;
    }

    if (item.getMessage().hasOnlyEmoji()) {
      setGiantEmoji(item.getMessage());
    } else if (item.getMessage().getMessage() != null &&
        managerMessageTextLayout != null &&
        managerMessageHeadTop != null &&
        managerMessageContextTop != null &&
        managerMessageText != null) {

      managerMessageTextLayout.setVisibility(View.VISIBLE);
      managerMessageHeadTop.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
      managerMessageContextTop.setVisibility(UIUtils.getVisible(isConnectedMessage, true));

      managerMessageText.setMovementMethod(CustomMovementMethod.getInstance());
      if (message != null) {
        managerMessageText.setText(message.getFormattedSpanMessage());
      }

      if (item.shouldTranslateMessage(message)) {
        hostMessageTranslationLayout.setVisibility(View.VISIBLE);
        setTranslationLayoutState(message);
      }
    }
  }


  private void setGiantEmoji(Message message) {
    if (giantEmojiText != null) {
      giantEmojiText.setVisibility(View.VISIBLE);
      giantEmojiText.setText(message.getFormattedSpanMessage());
    }
  }

  private void setTranslationLayoutState(Message message) {
    CharSequence messageContent = message.getFormattedSpanMessage();

    TranslationInfo translationInfo = TranslationSelector.get(TranslationInfo.createId(
        message.getId(),
        PrefSupervisor.getPluginLanguage(context)));

    if (translationInfo == null || TranslationState.ORIGIN.equals(translationInfo.getState())) {
      setTranslateLayoutWithoutProgress("show_translate", false);

    } else if (TranslationState.TRANSLATED.equals(translationInfo.getState())) {
      messageContent = translationInfo.getTranslatedMessage();
      setTranslateLayoutWithoutProgress("undo_translate", true);

    } else if (TranslationState.PROGRESS.equals(translationInfo.getState())) {
      translationButtonLayout.setVisibility(View.INVISIBLE);
      translationProgressView.setVisibility(View.VISIBLE);
    }

    if (managerMessageText != null) {
      managerMessageText.setText(messageContent);
    }
  }

  private void setTranslateLayoutWithoutProgress(String textKey, boolean isTranslated) {
    translationButtonLayout.setVisibility(View.VISIBLE);
    translationProgressView.setVisibility(View.GONE);
    translationButton.setTextByKey(textKey);
    translationButtonArrow.setVisibility(UIUtils.getVisible(isTranslated, true));
  }

  private void setTranslationButtonClickListener() {
    translationButton.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        if (message != null && listener != null) {
          TranslationInfo translationInfo = TranslationSelector.get(TranslationInfo.createId(
              message.getId(),
              PrefSupervisor.getPluginLanguage(context)));

          if (translationInfo == null || translationInfo.getState() != TranslationState.PROGRESS) {
            listener.onTranslationMessageClick(message);
          }
        }
      }
    });
  }
}
