package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.UserChat;

public class ClosedUserChatMessageItem implements MessageItem {

  private UserChat userChat;
  private long timestamp;

  public ClosedUserChatMessageItem(UserChat userChat, long timestamp) {
    this.userChat = userChat;
    this.timestamp = timestamp;
  }

  @Override
  public Long getPrimaryKey() {
    return timestamp;
  }

  @Override
  public String getSecondaryKey() {
    return "ClosedUserChatMessageItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.CLOSE;
  }

  public UserChat getUserChat() {
    return userChat;
  }
}
