/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.http;

import com.splunk.mint.Logger;
import com.splunk.mint.network.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public abstract class URLStreamHandlerBase
extends URLStreamHandler {
    static final Class<?>[] SIMPLE_FIELD_TYPES = new Class[]{URL.class, Integer.TYPE};
    static final Class<?>[] PROXY_FIELD_TYPES = new Class[]{URL.class, Integer.TYPE, Proxy.class};
    private Constructor<?> proxyConstructor;
    private Constructor<?> simpleConstructor;

    public URLStreamHandlerBase(String[] stringArray) throws ClassNotFoundException {
        this.initConstructors(stringArray);
        if (this.proxyConstructor == null || this.simpleConstructor == null) {
            throw new ClassNotFoundException("No implementation detected");
        }
    }

    private void initConstructors(String[] stringArray) {
        for (String string : stringArray) {
            try {
                this.proxyConstructor = ReflectionUtil.findConstructor(string, PROXY_FIELD_TYPES);
                this.simpleConstructor = ReflectionUtil.findConstructor(string, SIMPLE_FIELD_TYPES);
                this.proxyConstructor.setAccessible(true);
                this.simpleConstructor.setAccessible(true);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.proxyConstructor = null;
                this.simpleConstructor = null;
            }
        }
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        try {
            return (URLConnection)this.simpleConstructor.newInstance(uRL, this.getDefaultPort());
        }
        catch (InstantiationException instantiationException) {
            Logger.logError("Error initializing connection - can't instantiate object: " + instantiationException.getMessage());
            throw new IOException();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError("Error initializing connection - can't access constructor: " + illegalAccessException.getMessage());
            throw new IOException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.logError("Error initializing connection - invalid argument: " + illegalArgumentException.getMessage());
            throw new IOException();
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.logError("Error initializing connection - can't invoke target: " + invocationTargetException.getMessage());
            throw new IOException();
        }
    }

    @Override
    protected URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        if (proxy == null) {
            return this.openConnection(uRL);
        }
        try {
            return (URLConnection)this.proxyConstructor.newInstance(uRL, this.getDefaultPort(), proxy);
        }
        catch (InstantiationException instantiationException) {
            Logger.logError("Error initializing connection - can't instantiate object: " + instantiationException.getMessage());
            throw new IOException();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError("Error initializing connection - can't access constructor: " + illegalAccessException.getMessage());
            throw new IOException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.logError("Error initializing connection - invalid argument: " + illegalArgumentException.getMessage());
            throw new IOException();
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.logError("Error initializing connection - can't invoke target: " + invocationTargetException.getMessage());
            throw new IOException();
        }
    }

    @Override
    public abstract int getDefaultPort();

    public abstract String getProtocol();
}

