/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.http;

import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.http.MonitorableHttpURLConnection;
import com.splunk.mint.network.http.URLStreamHandlerBase;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public final class HTTPURLStreamHandler
extends URLStreamHandlerBase {
    private static final String[] SYSTEM_CLASSES = new String[]{"libcore.net.http.HttpURLConnectionImpl", "org.apache.harmony.luni.internal.net.www.protocol.http.HttpURLConnectionImpl", "org.apache.harmony.luni.internal.net.www.protocol.http.HttpURLConnection"};
    private static final int PORT = 80;
    private static final String PROTOCOL = "http";
    private final MonitorRegistry registry;

    public HTTPURLStreamHandler(MonitorRegistry monitorRegistry) throws ClassNotFoundException {
        super(SYSTEM_CLASSES);
        this.registry = monitorRegistry;
    }

    @Override
    protected final URLConnection openConnection(URL object) throws IOException {
        object = super.openConnection((URL)object);
        return new MonitorableHttpURLConnection(this.registry, (URLConnection)object);
    }

    @Override
    protected final URLConnection openConnection(URL object, Proxy proxy) throws IOException {
        object = super.openConnection((URL)object, proxy);
        return new MonitorableHttpURLConnection(this.registry, (URLConnection)object);
    }

    @Override
    public final int getDefaultPort() {
        return 80;
    }

    @Override
    public final String getProtocol() {
        return PROTOCOL;
    }
}

