/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.annotation.SuppressLint;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.view.WindowManager;
import com.splunk.mint.Logger;
import com.splunk.mint.Mint;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

class Utils {
    private static final int Verbose = 10;
    private static final int Debug = 20;
    private static final int Info = 30;
    private static final int Warning = 50;
    private static final int Error = 60;
    protected static final String CONNECTION = "connection";
    protected static final String STATE = "state";

    Utils() {
    }

    protected static String getRandomSessionNumber() {
        return UUID.randomUUID().toString();
    }

    protected static String getScreenOrientation(Context context) {
        context = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        int n2 = context.getOrientation();
        String string = "NA";
        switch (n2) {
            case 0: {
                string = "Portrait";
                break;
            }
            case 2: {
                string = "PortraitUpsideDown";
                break;
            }
            case 3: {
                string = "LandscapeLeft";
                break;
            }
            case 1: {
                string = "LandscapeRight";
            }
        }
        return string;
    }

    protected static final boolean isKitKat() {
        return Build.VERSION.SDK_INT == 19;
    }

    protected static int convertLoggingLevelToInt(MintLogLevel mintLogLevel) {
        if (mintLogLevel.equals((Object)MintLogLevel.Debug)) {
            return 20;
        }
        if (mintLogLevel.equals((Object)MintLogLevel.Error)) {
            return 60;
        }
        if (mintLogLevel.equals((Object)MintLogLevel.Info)) {
            return 30;
        }
        if (mintLogLevel.equals((Object)MintLogLevel.Verbose)) {
            return 10;
        }
        if (mintLogLevel.equals((Object)MintLogLevel.Warning)) {
            return 50;
        }
        return 10;
    }

    protected static HashMap<String, String> getConnectionInfo(Context context) {
        HashMap<String, String> hashMap;
        block13: {
            hashMap = new HashMap<String, String>(2);
            hashMap.put(CONNECTION, "NA");
            hashMap.put(STATE, "NA");
            if (context == null) {
                if (Mint.DEBUG) {
                    Logger.logError("Context in getConnection is null!");
                }
            } else {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager == null) {
                    if (Mint.DEBUG) {
                        Logger.logError("PackageManager in CheckNetworkConnection is null!");
                    }
                } else {
                    try {
                        if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", Properties.APP_PACKAGE) == 0) {
                            context = (ConnectivityManager)context.getSystemService("connectivity");
                            if ((context = context.getActiveNetworkInfo()) != null) {
                                if (context.getSubtypeName() == null || context.getSubtypeName().length() == 0) {
                                    hashMap.put(CONNECTION, context.getTypeName());
                                } else {
                                    hashMap.put(CONNECTION, context.getSubtypeName());
                                }
                                hashMap.put(STATE, context.getState().toString());
                            } else {
                                hashMap.put(CONNECTION, "No Connection");
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!Mint.DEBUG) break block13;
                        Logger.logError("Could not get network connection state");
                        exception.printStackTrace();
                    }
                }
            }
        }
        return hashMap;
    }

    protected static byte isGPSOn(Context context) {
        byte by;
        block5: {
            by = 0;
            PackageManager packageManager = context.getPackageManager();
            try {
                if (packageManager.checkPermission("android.permission.ACCESS_FINE_LOCATION", Properties.APP_PACKAGE) == 0) {
                    if (!(context = (LocationManager)context.getSystemService("location")).isProviderEnabled("gps")) {
                        by = 1;
                    }
                } else {
                    by = 2;
                }
            }
            catch (Exception exception) {
                by = 2;
                if (!Mint.DEBUG) break block5;
                Logger.logError("Could not get GPS state");
                exception.printStackTrace();
            }
        }
        return by;
    }

    protected static final String getTime() {
        String string = String.valueOf(System.currentTimeMillis());
        try {
            string = String.valueOf(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L);
        }
        catch (Exception exception) {
            Logger.logWarning("Could not get the UTC time");
        }
        return string;
    }

    protected static boolean checkForRoot() {
        boolean bl = false;
        String[] stringArray = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"};
        stringArray = stringArray;
        for (int i2 = 0; i2 < 8; ++i2) {
            Object object = stringArray[i2];
            if (!((File)(object = new File((String)object + "su"))).exists()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected static final Long getMilisFromStart() {
        if (Properties.TIMESTAMP == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - Properties.TIMESTAMP;
    }

    protected static final String getCarrier(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) != null) {
            String string = null;
            try {
                if (context.getSimState() == 5) {
                    string = context.getSimOperatorName();
                }
            }
            catch (Exception exception) {}
            try {
                if (string == null || string.length() == 0) {
                    string = context.getNetworkOperatorName();
                }
            }
            catch (Exception exception) {}
            if (string == null || string.length() == 0) {
                string = "NA";
            }
            return string;
        }
        return "NA";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String readFile(String object) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("filePath Argument is null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader((String)object));
            while ((object = bufferedReader.readLine()) != null) {
                stringBuilder.append((String)object);
            }
        }
        catch (Exception exception) {
            try {
                object = exception;
                throw exception;
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    throw iOException;
                }
            }
        }
        try {
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
    }

    protected static final String readLogs() {
        int n2 = Properties.LOG_LINES;
        if (n2 < 0) {
            n2 = 100;
        }
        Object object = Properties.LOG_FILTER;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            object = Runtime.getRuntime().exec("logcat -d " + (String)object);
            object = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = ((BufferedReader)object).readLine()) != null) {
                arrayList.add(string);
            }
            if (arrayList.size() == 0) {
                return "You must add the android.permission.READ_LOGS permission to your manifest file!";
            }
            n2 = arrayList.size() - n2;
            if (n2 < 0) {
                n2 = 0;
            }
            while (n2 < arrayList.size()) {
                stringBuilder.append((String)arrayList.get(n2) + "\n");
                ++n2;
            }
            return stringBuilder.toString().replaceAll(Pattern.quote("}{^"), "}{ ^");
        }
        catch (Exception exception) {
            Logger.logError("Error reading logcat output!");
            return exception.getMessage();
        }
    }

    protected static final HashMap<String, String> getMemoryInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        try {
            boolean bl = false;
            boolean bl2 = false;
            Object object = new String[]{"/system/bin/cat", "/proc/meminfo"};
            object = new ProcessBuilder((String[])object);
            object = ((ProcessBuilder)object).start();
            object = ((Process)object).getInputStream();
            Serializable serializable = new StringBuilder();
            Object[] objectArray = new byte[1024];
            while (((InputStream)object).read((byte[])objectArray) != -1) {
                ((StringBuilder)serializable).append(new String((byte[])objectArray));
                String[] stringArray = ((StringBuilder)serializable).toString().split("kB");
                if (stringArray.length < 2) continue;
                serializable = new DecimalFormat("#.##");
                objectArray = stringArray;
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string;
                    byte by = objectArray[i2];
                    if (!bl && by.contains("MemTotal:")) {
                        string = by.substring(by.indexOf(" "), by.lastIndexOf(" ")).trim();
                        hashMap.put("memTotal", String.valueOf(((NumberFormat)serializable).format(Float.valueOf(string).floatValue() / 1024.0f)));
                        bl = true;
                    }
                    if (bl2 || !by.contains("MemFree:")) continue;
                    string = by.substring(by.indexOf(" "), by.lastIndexOf(" ")).trim();
                    hashMap.put("memFree", String.valueOf(((NumberFormat)serializable).format(Float.valueOf(string).floatValue() / 1024.0f)));
                    bl2 = true;
                }
            }
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        return hashMap;
    }

    protected static boolean allowedToSendData() {
        if (!Properties.flushOnlyOverWiFi) {
            return true;
        }
        return Properties.CONNECTION.equals("WIFI");
    }

    @SuppressLint(value={"NewApi"})
    protected static String isFSEncrypted(Context context) {
        if (context != null && (context = (DevicePolicyManager)context.getSystemService("device_policy")) != null && Build.VERSION.SDK_INT > 11) {
            try {
                int n2 = context.getStorageEncryptionStatus();
                if (3 == n2) {
                    return "true";
                }
                return "false";
            }
            catch (Exception exception) {}
        }
        return "NA";
    }

    public static int getBatteryLevel(Context context) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 5 && (context = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"))) != null) {
            n2 = context.getIntExtra("level", -1);
            int n3 = context.getIntExtra("scale", -1);
            if (n2 == -1 || n3 == -1) {
                return 50;
            }
            return Math.round((float)n2 / (float)n3 * 100.0f);
        }
        return 50;
    }
}

