/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.app.ActivityManager;
import android.content.Context;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.DataSaver;
import com.splunk.mint.EnumStateStatus;
import com.splunk.mint.InterfaceDataType;
import com.splunk.mint.NetSender;
import com.splunk.mint.Properties;
import com.splunk.mint.StacktraceHash;
import com.splunk.mint.Utils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ActionError
extends BaseDTO
implements InterfaceDataType {
    private String stacktrace;
    private Boolean handled;
    private String klass;
    private String message;
    private String errorHash;
    private String where;
    private byte gpsStatus;
    private String memSysTotal = null;
    private String memSysLow;
    private String memSysAvailable = null;
    private String memSysThreshold;
    private String memAppMax;
    private String memAppAvailable;
    private String memAppTotal;
    private JSONArray breadcrumbs;

    public ActionError(byte by, String object, byte by2, HashMap<String, Object> hashMap) {
        super(by, hashMap);
        this.stacktrace = object;
        this.handled = by2 == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        ActivityManager.MemoryInfo memoryInfo = StacktraceHash.manipulateStacktrace(Properties.APP_PACKAGE, (String)object);
        this.klass = memoryInfo.get("klass");
        this.message = memoryInfo.get("message");
        this.errorHash = memoryInfo.get("errorHash");
        this.where = memoryInfo.get("where");
        this.gpsStatus = Properties.IS_GPS_ON;
        memoryInfo = new ActivityManager.MemoryInfo();
        object = Runtime.getRuntime();
        if (!this.handled.booleanValue()) {
            HashMap<String, String> hashMap2 = Utils.getMemoryInfo();
            this.memSysTotal = hashMap2.get("memTotal");
            this.memSysAvailable = hashMap2.get("memFree");
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        this.memSysThreshold = String.valueOf(decimalFormat.format((double)memoryInfo.threshold / 1048576.0));
        this.memSysLow = String.valueOf(memoryInfo.lowMemory);
        this.memAppMax = String.valueOf(decimalFormat.format((double)((Runtime)object).maxMemory() / 1048576.0));
        this.memAppAvailable = String.valueOf(decimalFormat.format((double)((Runtime)object).freeMemory() / 1048576.0));
        this.memAppTotal = String.valueOf(decimalFormat.format((double)((Runtime)object).totalMemory() / 1048576.0));
        this.breadcrumbs = Properties.breadcrumbs.getList();
    }

    public ActionError(byte by, String object, String object2, String string, String string2, HashMap<String, Object> hashMap, byte by2) {
        super(by, hashMap);
        this.stacktrace = string2;
        this.handled = by2 == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.klass = object2;
        this.message = object;
        this.errorHash = StacktraceHash.getMD5ForJavascriptError(string2);
        this.where = "line: " + string;
        this.gpsStatus = Properties.IS_GPS_ON;
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        object = Runtime.getRuntime();
        if (!this.handled.booleanValue()) {
            object2 = Utils.getMemoryInfo();
            this.memSysTotal = (String)((HashMap)object2).get("memTotal");
            this.memSysAvailable = (String)((HashMap)object2).get("memFree");
        }
        object2 = new DecimalFormat("#.##");
        this.memSysThreshold = String.valueOf(((NumberFormat)object2).format((double)memoryInfo.threshold / 1048576.0));
        this.memSysLow = String.valueOf(memoryInfo.lowMemory);
        this.memAppMax = String.valueOf(((NumberFormat)object2).format((double)((Runtime)object).maxMemory() / 1048576.0));
        this.memAppAvailable = String.valueOf(((NumberFormat)object2).format((double)((Runtime)object).freeMemory() / 1048576.0));
        this.memAppTotal = String.valueOf(((NumberFormat)object2).format((double)((Runtime)object).totalMemory() / 1048576.0));
        this.breadcrumbs = Properties.breadcrumbs.getList();
    }

    protected final String getErrorHash() {
        return this.errorHash;
    }

    @Override
    public String toJsonLine() {
        JSONObject jSONObject = this.getBasicDataFixtureJson();
        try {
            Object object = new JSONObject();
            object.put("0", (Object)this.stacktrace);
            jSONObject.put("stacktrace", object);
            jSONObject.put("threadCrashed", (Object)"0");
            jSONObject.put("handled", (Object)this.handled);
            jSONObject.put("klass", (Object)this.klass);
            jSONObject.put("message", (Object)this.message);
            jSONObject.put("errorHash", (Object)this.errorHash);
            jSONObject.put("where", (Object)this.where);
            jSONObject.put("rooted", Properties.HAS_ROOT);
            jSONObject.put("gpsStatus", (Object)EnumStateStatus.getStringFromStatus(this.gpsStatus));
            jSONObject.put("breadcrumbs", (Object)this.breadcrumbs);
            jSONObject.put("memSysLow", (Object)this.memSysLow);
            if (!this.handled.booleanValue()) {
                jSONObject.put("memSysTotal", (Object)this.memSysTotal);
                jSONObject.put("memSysAvailable", (Object)this.memSysAvailable);
            }
            jSONObject.put("memSysThreshold", (Object)this.memSysThreshold);
            jSONObject.put("memAppMax", (Object)this.memAppMax);
            jSONObject.put("memAppAvailable", (Object)this.memAppAvailable);
            jSONObject.put("memAppTotal", (Object)this.memAppTotal);
            if (Properties.SEND_LOG) {
                object = Utils.readLogs();
                jSONObject.put("log", object);
            } else {
                jSONObject.put("log", (Object)"NA");
            }
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
        }
        return jSONObject.toString() + Properties.getSeparator((byte)0);
    }

    @Override
    public void send(boolean bl) {
        NetSender.send(this.toJsonLine(), bl);
    }

    @Override
    public void save() {
        DataSaver.save(this.toJsonLine());
    }

    @Override
    public void send(Context context, boolean bl) {
        NetSender.send(this.toJsonLine(), bl);
    }
}

