/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.graphics.Color;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.TimeRange;
import com.zoyi.channel.plugin.android.model.rest.WorkingTime;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class Channel
implements ProfileEntity {
    public static final String EXPECTED_RESPONSE_DELAY_INSTANT = "instant";
    public static final String EXPECTED_RESPONSE_DELAY_NORMAL = "normal";
    public static final String EXPECTED_RESPONSE_DELAY_DELAYED = "delayed";
    private String id;
    private String name;
    private String description;
    private String country;
    private Long createdAt;
    private String domain;
    private String color;
    private String textColor;
    private String userInfoUrl;
    private String timeZone;
    private String initial;
    private String avatarUrl;
    private Boolean working;
    private Boolean outOfWorkPlugin;
    private String servicePlan;
    private Boolean serviceBlocked;
    private WorkingTime workingTime;
    private TimeRange lunchTime;
    private String homepageUrl;
    private String phoneNumber;
    private boolean requestGuestInfo;
    private String expectedResponseDelay;
    public static final String CLASSNAME = "Channel";

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCountry() {
        return this.country;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getColor() {
        return this.color;
    }

    public String getUserInfoUrl() {
        return this.userInfoUrl;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getPersonType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getBackgroundColor() {
        try {
            return Color.parseColor((String)this.color);
        }
        catch (Exception exception) {
            return -16777216;
        }
    }

    @Override
    public int getTextColor() {
        return "black".equals(this.textColor) ? -16777216 : -1;
    }

    @Override
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @Override
    public String getInitial() {
        return this.initial;
    }

    public boolean isWorkingPlugin() {
        if (this.working != null && this.outOfWorkPlugin != null) {
            if (this.working.booleanValue()) {
                return this.working;
            }
            return this.outOfWorkPlugin == false;
        }
        return false;
    }

    public String getWorkingTime(Context context) {
        String launch;
        String string2 = launch = this.lunchTime != null ? String.format("%s: %s", ResUtils.getString(context, "ch.out_of_work.lunch_time"), TimeUtils.getTimeRangeString(this.lunchTime)) : null;
        if (this.workingTime != null) {
            String work = this.workingTime.getMessage(context);
            if (launch != null) {
                return String.format("Timezone: %s<br><br>%s<br><br>%s", this.timeZone, work, launch);
            }
            return String.format("Timezone: %s<br><br>%s", this.timeZone, work);
        }
        return "";
    }

    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public boolean isRequestGuestInfo() {
        return this.requestGuestInfo;
    }

    public String getExpectedResponseDelay() {
        return this.expectedResponseDelay;
    }

    public String getServicePlan() {
        return this.servicePlan;
    }

    public Boolean getServiceBlocked() {
        return this.serviceBlocked;
    }

    public boolean isBlocked() {
        return "free".equals(this.getServicePlan()) || this.getServiceBlocked() != false;
    }
}

