/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import com.zoyi.channel.plugin.android.activity.base.BaseDictionary;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserChatListDataDictionary
extends BaseDictionary {
    private static UserChatListDataDictionary instance;
    private Map<String, Session> sessionMap = new HashMap<String, Session>();
    private Map<String, Message> messageMap = new HashMap<String, Message>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserChatListDataDictionary getInstance() {
        if (instance != null) return instance;
        Class<UserChatListDataDictionary> clazz = UserChatListDataDictionary.class;
        synchronized (UserChatListDataDictionary.class) {
            if (instance != null) return instance;
            instance = new UserChatListDataDictionary();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private UserChatListDataDictionary() {
    }

    @Override
    public void release() {
        super.release();
        if (this.sessionMap != null) {
            this.sessionMap.clear();
        }
        if (this.messageMap != null) {
            this.messageMap.clear();
        }
    }

    @Override
    public <E extends ChannelModel> E get(Class<E> clazz, String id2) {
        if (id2 != null) {
            String className;
            switch (className = clazz.getSimpleName()) {
                case "Manager": {
                    return (E)((ChannelModel)this.managerMap.get(id2));
                }
                case "Bot": {
                    return (E)((ChannelModel)this.botMap.get(id2));
                }
                case "Session": {
                    return (E)this.sessionMap.get(id2);
                }
                case "Message": {
                    return (E)this.messageMap.get(id2);
                }
            }
        }
        return null;
    }

    @Override
    public void add(List<? extends ChannelModel> channelModels) {
        if (channelModels != null) {
            for (ChannelModel channelModel : channelModels) {
                String className;
                if (!this.checkCanUpdate(channelModel)) continue;
                switch (className = channelModel.getClass().getSimpleName()) {
                    case "Manager": {
                        this.managerMap.put(channelModel.getId(), (Manager)channelModel);
                        break;
                    }
                    case "Bot": {
                        this.botMap.put(channelModel.getId(), (Bot)channelModel);
                        break;
                    }
                    case "Session": {
                        this.sessionMap.put(channelModel.getId(), (Session)channelModel);
                        break;
                    }
                    case "Message": {
                        this.messageMap.put(channelModel.getId(), (Message)channelModel);
                    }
                }
            }
        }
    }

    @Override
    public void remove(ChannelModel channelModel) {
        String className;
        switch (className = channelModel.getClass().getSimpleName()) {
            case "Manager": {
                if (!this.managerMap.containsKey(channelModel.getId())) break;
                this.managerMap.remove(channelModel.getId());
                break;
            }
            case "Session": {
                if (!this.sessionMap.containsKey(channelModel.getId())) break;
                this.sessionMap.remove(channelModel.getId());
                break;
            }
            case "Message": {
                if (!this.messageMap.containsKey(channelModel.getId())) break;
                this.messageMap.remove(channelModel.getId());
            }
        }
    }
}

