/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.base;

import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.UpdatedModel;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseDictionary {
    protected Map<String, Manager> managerMap = new HashMap<String, Manager>();
    protected Map<String, Bot> botMap = new HashMap<String, Bot>();

    public void release() {
        if (this.managerMap != null) {
            this.managerMap.clear();
        }
        if (this.botMap != null) {
            this.botMap.clear();
        }
    }

    protected abstract <E extends ChannelModel> E get(Class<E> var1, String var2);

    protected abstract void add(List<? extends ChannelModel> var1);

    protected abstract void remove(ChannelModel var1);

    public void add(ChannelModel channelModel) {
        this.add(Collections.singletonList(channelModel));
    }

    protected boolean checkCanUpdate(ChannelModel channelModel) {
        if (channelModel instanceof UpdatedModel) {
            Object model = this.get(channelModel.getClass(), channelModel.getId());
            if (model == null) {
                return true;
            }
            if (model instanceof UpdatedModel) {
                UpdatedModel oldbie = (UpdatedModel)model;
                UpdatedModel newbie = (UpdatedModel)((Object)channelModel);
                return CompareUtils.compare(oldbie.getUpdatedAt(), newbie.getUpdatedAt()) < 0;
            }
        }
        return true;
    }

    public ProfileEntity getProfile(String personType, String personId) {
        if (personType == null || personId == null) {
            return null;
        }
        switch (personType) {
            case "Manager": {
                return this.managerMap.get(personId);
            }
            case "Bot": {
                return this.botMap.get(personId);
            }
        }
        return null;
    }
}

