package com.zoyi.channel.plugin.android.presenter.userchat;

import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;

public interface UserChatAdapterContract {

  interface View {

    void setOnUserChatClickListener(OnUserChatClickListener clickListener);

    void removeUserChat(String chatId);
  }

  interface Model {

    void clear();
    void init(UserChatsWrapper wrapper);
    void stopRefreshBySocket();

    void removeItem(UserChat userChat);
    void updateItem(UserChatItem item);
    void addOrUpdateItem(UserChat userChat);

    void updateManager(String managerId);
    void updateSession(Session session);
  }

}
