package com.zoyi.channel.plugin.android.presenter.settings;

import android.content.Context;

import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.wrapper.CountryWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserVeilWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.util.ArrayList;
import java.util.List;

public class ProfileEditPresenter implements ProfileEditContract.Presenter {

  private Context context;

  private ProfileEditContract.View view;

  private List<Country> countries;

  public ProfileEditPresenter(Context context) {
    this.context = context;
    countries = new ArrayList<>();
  }

  @Override
  public void setView(ProfileEditContract.View view) {
    this.view = view;
  }

  @Override
  public void updateUserName(String name) {
    updateUser(RequestUtils.form().set("name", name).create());
  }

  @Override
  public void updateUserMobileNumber(String mobileNumber) {
    updateUser(RequestUtils.form().set("mobileNumber", mobileNumber).create());
  }

  private void updateUser(RequestBody body) {
    view.showProgress(ResUtils.getString(context, "ch.settings.changing_message"));

    ChannelPlugin.getApi().updateGuest(body)
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<UserVeilWrapper>() {
          @Override
          public void onError(RetrofitException e) {
            view.hideProgress();

            view.onShowFailedMessage(e.getMessage());
          }

          @Override
          public void onNext(UserVeilWrapper wrapper) {
            view.hideProgress();

            if (wrapper != null) {
              ChannelStore.setUserVeil(wrapper.getUser(), wrapper.getVeil());

              view.onUpdateSuccessed();
            }
          }
        });
  }

  @Override
  public void getCountries() {
    if (countries == null || countries.isEmpty()) {
      view.showProgress(ResUtils.getString(context, "ch.loading_information"));

      ChannelPlugin.getApi().getCountries()
          .subscribeOn(Schedulers.newThread())
          .observeOn(AndroidSchedulers.mainThread())
          .subscribe(new RestSubscriber<CountryWrapper>() {
            @Override
            public void onError(RetrofitException e) {
              view.hideProgress();

              view.onShowFailedMessage(e.getMessage());
            }

            @Override
            public void onNext(CountryWrapper countryWrapper) {
              view.hideProgress();

              if (countryWrapper != null) {
                countries = countryWrapper.getCountries();

                view.onLoadedCountries(countries);
              }
            }
          });
    } else {
      view.onLoadedCountries(countries);
    }
  }
}
