package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.wrapper.ChannelWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.CountryWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.DeviceTokenBox;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ManagersWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ScriptWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ScriptsWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserVeilWrapper;
import com.zoyi.okhttp3.MultipartBody;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.retrofit2.http.Body;
import com.zoyi.retrofit2.http.DELETE;
import com.zoyi.retrofit2.http.GET;
import com.zoyi.retrofit2.http.Header;
import com.zoyi.retrofit2.http.HeaderMap;
import com.zoyi.retrofit2.http.Headers;
import com.zoyi.retrofit2.http.Multipart;
import com.zoyi.retrofit2.http.POST;
import com.zoyi.retrofit2.http.PUT;
import com.zoyi.retrofit2.http.Part;
import com.zoyi.retrofit2.http.Path;
import com.zoyi.retrofit2.http.Query;
import com.zoyi.rx.Observable;

import java.util.Map;

/**
 * Created by mika on 2016. 1. 20..
 */
public interface ChannelApi {
  @GET("packages/{packageId}/versions/latest")
  Observable<PackageWrapper> getLastestPackage(@Path("packageId") String packageId, @Query("from") String from);

  @Headers({"Content-Type: application/json"})
  @POST("/app/plugins/{key}/check_in")
  Observable<PluginWrapper> checkIn(@HeaderMap Map<String, String> headers, @Path("key") String key, @Query("url") String url, @Body RequestBody body);

  @GET("/app/plugins/{pluginId}")
  Observable<PluginWrapper> getPlugin(@Path("pluginId") String pluginId);

  @GET("/app/plugins/{pluginId}/scripts")
  Observable<ScriptsWrapper> getScripts(@Path("pluginId") String pluginId);

  @GET("/app/plugins/{pluginId}/scripts/{scriptKey}")
  Observable<ScriptWrapper> getScript(@Path("pluginId") String pluginId, @Path("scriptKey") String scriptKey);

  @GET("/app/guests/me")
  Observable<GuestWrapper> getMe();

  @GET("/app/user_chats")
  Observable<UserChatsWrapper> getUserChats(@Query("sortField") String sortField, @Query("sortOrder") String sortOrder, @Query("limit") Integer limit, @Query("states") String... states);

  @GET("/app/user_chats/{userChatId}")
  Observable<UserChatWrapper> getUserChat(@Path("userChatId") String userChatId);

  @GET("/app/user_chats/{userChatId}/messages")
  Observable<MessagesWrapper> getMessages(@Path("userChatId") String userChatId, @Query("since") String since, @Query("limit") Integer limit, @Query("sortOrder") String sortOrder);

  @POST("/app/plugins/{pluginId}/user_chats")
  Observable<UserChatWrapper> createUserChat(@Header("X-Plugin-Key") String key, @Path("pluginId") String pluginId, @Query("welcomedAt") long welcomedAt);

  @PUT("/app/user_chats/{userChatId}/messages/read_all")
  Observable<Void> readAll(@Path("userChatId") String userChatId);

  @Headers({"Content-Type: application/json"})
  @POST("/app/user_chats/{userChatId}/messages")
  Observable<MessageWrapper> sendMessage(@Path("userChatId") String userChatId, @Body RequestBody body);

  @Multipart
  @POST("/app/user_chats/{userChatId}/messages/file")
  Observable<MessageWrapper> uploadFile(@Path("userChatId") String userChatId, @Part MultipartBody.Part file, @Part("requestId") RequestBody requestId);

  @Headers({"Content-Type: application/json"})
  @PUT("/app/guests")
  Observable<UserVeilWrapper> updateGuest(@Body RequestBody body);

  @Headers({"Content-Type: application/json"})
  @POST("app/device_tokens")
  Observable<DeviceTokenBox> sendToken(@Body RequestBody body);

  @Headers({"Content-Type: application/json"})
  @DELETE("app/device_tokens/{platform}/{key}")
  Observable<Void> deleteToken(@Header("X-Channel-Id") String channelId, @Path("platform") String platform, @Path("key") String key);

  @Headers({"Content-Type: application/json"})
  @PUT("app/user_chats/{userChatId}/remove")
  Observable<Void> removeUserChat(@Path("userChatId") String userChatId);

  // TODO : Replace done to close
  @Headers({"Content-Type: application/json"})
  @PUT("app/user_chats/{userChatId}/done")
  Observable<UserChatWrapper> reviewUserChat(@Path("userChatId") String userChatId, @Query("review") String review);

  @GET("/countries")
  Observable<CountryWrapper> getCountries();

  @POST("/app/events")
  Observable<Void> trackEvent(@Body Event event);

  @GET("/app/channels")
  Observable<ChannelWrapper> getChannels();

  @GET("/app/channels/following_managers")
  Observable<ManagersWrapper> getFollowingManagers();
}
